

class Ligands:
    """ ligands contains the list of ligands AND the list of FingerPrints.
        The number of ligands have to be the same that the number of fingerprints
        arguments:
            sizeFP : the size of FingerPrints (7 or11)
            tablig : a list of ligand (address)
            tabFP  : a list of Fingerprints
            dico   : a dictionnary that make a correspondance between 
                     the ligand and the FingerPrints
        """
    
    def __init__(self,tlig,tFP,tailleFP):
        """ constructor:
            parametters:
                tlig : a list of ligands (adress of files)
                tFP : alist of FingerPrints
                tailleFP : the size of Fingerprint by residu (7 or 11)
                """
        if len(tlig) != len(tFP):
            print "il n' y a pas autant de ligand que de FP"
            print "il y a ", len(tlig), " ligands et ",len(tFP)," FingerPrints"
            print "il faut que ces deux nombre concoredent!!!"
            return(0)
        self.sizeFP=tailleFP
        self.tablig = tlig
        self.tabFP = tFP
        self.dico={}
        self.createdico()
        
    def createdico(self):
        """this function fill the dico"""
        
        for i in range (len(self.tablig)):
            self.dico[self.tablig[i]] = self.tabFP[i]
            
#testlig=[]
#testFP=[]
#testlig.append("./struct/ibmxcorinaH.mol2")
#testlig.append( "./struct/ibmxtoto3D.mol2")
#testFP.append("010101010111000000000010")
#testFP.append("010101010111000000000010")
#
#lig = Ligands(testlig,testFP)
#print lig.dico
