from canva import *
import Tkinter,tkFileDialog
import Pmw,tkMessageBox 
import cavite

class Launcher(Frame):
    
    def __init__(self,boss = None):
        Frame.__init__(self,boss)
        
        self.monlabel= Label(self,text="input for the pymol view of FingerPrints:",anchor=CENTER)
        self.monlabel.grid(row=0,sticky='NSEW')
        
        
        
        mongroup1 = Pmw.Group(self,tag_text = "Cavity")
        mongroup1.grid(row=1,column=0,sticky='NSEW')
        self.monlabel= Label(mongroup1.interior(),text="Binding site",anchor=CENTER)
        self.monlabel.pack()
        self.cavEntree = Entry(mongroup1.interior(),width=42)
        self.cavEntree.pack()
        monBouton = Button(mongroup1.interior(),relief=RAISED,text="browse...",command = self.browseCav,width=40)
        monBouton.pack(side = 'right')
        
        
        
        mongroup2 = Pmw.Group(self,tag_text = "List of ligands")
        mongroup2.grid(row=1,column=1,sticky='NSEW')
        self.monlabel= Label(mongroup2.interior(),text="Ligands list",anchor=CENTER)
        self.monlabel.pack()
        self.ligEntree = Entry(mongroup2.interior(),width = 42)
        self.ligEntree.pack()
        monBouton = Button(mongroup2.interior(),relief=RAISED,text="browse...",command = self.browseLig,width = 40)
        monBouton.pack(side = 'right')
        
        mongroup3 = Pmw.Group(self,tag_text = "List of Fingerprints")
        mongroup3.grid(row=2,column=0,sticky='NSEW')
        self.monlabel= Label(mongroup3.interior(),text="Fingerprint list",anchor=CENTER)
        self.monlabel.pack()
        self.FPEntree = Entry(mongroup3.interior(),width = 42)
        self.FPEntree.pack()
        monBouton = Button(mongroup3.interior(),relief=RAISED,text="browse...",command = self.browseFP,width = 40)
        monBouton.pack(side = 'right')
        
        
        
        mongroup4 = Pmw.Group(self,tag_text = "size of FingerPrints")
        mongroup4.grid(row=2,column=1,sticky='NSEW')
        self.v = StringVar()
        self.v.set("0")
        self.u=0
        
        #self.RadBut1 = Radiobutton(mongroup4.interior(), text="7", variable=self.v, value="7",width = 40,anchor='w',height=2)
        self.RadBut1 = Radiobutton(mongroup4.interior(), text="7", command = self.setU7,variable=self.v, value="7",width = 40,anchor='w',height=2)
        self.RadBut1.pack()
        #self.RadBut2 = Radiobutton(mongroup4.interior(), text="11", variable=self.v, value="11",width = 40,anchor='w',height=2)
        self.RadBut2 = Radiobutton(mongroup4.interior(), text="11",command = self.setU11, variable=self.v, value="11",width = 40,anchor='w',height=2)
        self.RadBut2.pack()

        
        
        monBouton = Button(self,relief=RAISED,text="OK",command = self.ok)
        monBouton.grid(row=4,column =0,sticky='NSEW')
        
        monBouton = Button(self,relief=RAISED,text="Cancel",command = self.quit)
        monBouton.grid(row=4,column =1,sticky='NSEW')
        

        self.cavEntree.insert(0,"/home/nath/Projects/pymolFP/struct/nico/refcavite.pdb")
        self.ligEntree.insert(0,"/home/nath/Projects/pymolFP/struct/nico/list")
        self.FPEntree.insert(0,"/home/nath/Projects/pymolFP/struct/nico/listFP7")
        #self.pack()
        
    
    def setU7(self):
        self.u=7
        
    def setU11(self):
        self.u=11
        
    def ok(self):
        cav = self.cavEntree.get()
        ligs =  self.ligEntree.get()
        FP =  self.FPEntree.get()
        sizeFP = self.u
        
        if ((cav == "" )or(ligs=="")or(FP=="")or(sizeFP==0)):
            tkMessageBox.showwarning(
                "check the input",
                "you don't give all the infos" 
                
            )
            return
        
       
        self.myligs = Ligands(self.parse(self.ligEntree.get()),self.parse(self.FPEntree.get()),self.u)
        
        
        self.mycav = Cavite(self.cavEntree.get())
        self.quit()
#        can = FenPrinc(cav,ligs,700,500)
#        can.printcav()
#        can.printLigs()
#        can.mainloop()
      
    def browseCav(self):
        myFormat=[("pdb","*.pdb")]
        file = tkFileDialog.askopenfile(parent=self,initialdir="../struct/nico",mode='rb',title='Choose a file',filetypes=myFormat)
        if file != None:
            self.cavEntree.delete(0,END)
            self.cavEntree.insert(0,file.name)
            
    def browseLig(self):
        file = tkFileDialog.askopenfile(parent=self,initialdir="../struct/nico",mode='rb',title='Choose a file')
        if file != None:
            self.ligEntree.delete(0,END)
            self.ligEntree.insert(0,file.name)
           
    def browseFP(self):
        file = tkFileDialog.askopenfile(parent=self,initialdir="../struct/nico",mode='rb',title='Choose a file')
        if file != None:
            self.FPEntree.delete(0,END)
            self.FPEntree.insert(0,file.name)
            
    def parse(self,file):
        fic=open(file,'r')
        res=[]
        while (1):
            line=fic.readline()
            line.strip('\n')
            if ((line=="")or (line=="\n")):
                break
            line =  line[0:len(line)-1]
            res.append(line)
        #print res
        return res
        
            
#
#main = testFrame()
#test = Toplevel(main)
#test.title (" toto")
#main.mainloop()
