from Tkinter import *
from cavite import *
from ligands import *
from pymol import *

import Pmw

Pmw.initialise()


class FenPrinc( Pmw.ScrolledCanvas ):
    """ this object a custom scrolledCanva
        arguments:
            cav : the cavity (object Cavite)
            ligs : the ligands (object Ligands)
            colors: a list of colors used to print FingerPrints
            width : the width of the scrolledCanva
            height : the height of the scrolledCanva
            tabAA : the list of residu
            tabLig : the list of ligand (adress of files)
            
            """
            
    def rvb( self, r, v, b ):
        """ a litle function that creat a rgv color"""
        return "#%02x%02x%02x" % ( int( r ), int( v ), int( b ) )
    
    
    def __init__( self, master, cavit, ligand, width, height ):
        """ constructor:
            parametters : 
                cavit : a cavity (object Cavite)
                ligand : a Ligands (object Ligands)
                width and height
                """
        self.cav=cavit
        self.ligs = ligand
        self.colors = ( 'blue', 'green', 'green', 'red', 'red', 'yellow', 'yellow', self.rvb( 255, 150, 150 ), self.rvb( 255, 150, 150 ), 'cyan', 'magenta' )
        self.FPn = [0, 0]
        self.current=[0,0]
        self.listener=[]
        self.width = width
        self.height = height
        Pmw.ScrolledCanvas.__init__( self, master, 
                       usehullsize = 1, hull_width = self.width, hull_height = self.height, 
                       canvas_bg = self.rvb( 255, 255, 255 ),
                       canvasmargin = 10, 
                       labelpos = N, #label_text = 'output clean de FP', 
                       borderframe = 1, 
                       borderframe_borderwidth = 3 )
        self.configure( vscrollmode='dynamic', hscrollmode = 'dynamic' )
        self.pack( padx = 5, pady = 5, expand = YES, fill = BOTH )
        self.can = self.interior()
        
        self.can.bind( "<ButtonRelease-1>", self.onClique )
        
        self.resizescrollregion()
        
        
    def printcav ( self ):
        """print the residus at the top of the scrolledCaneva"""
        
        pas = self.ligs.sizeFP*7
        i=0
        self.tabAA=[]
        for AA in self.cav.cavord :
            self.can.create_text( pas*i + 203 +pas/5, 30, text = AA, font = "Arial 10 bold", fill = "black" )
            self.tabAA.append( AA )
            i=i+1
        self.pyCav()

    def printLigs( self ):
        """print the list of ligands at the left of the scrolledCanva"""
        pas = 15
        i=0
        self.tablig=[]
        for ligName in self.ligs.dico.keys() :
            self.tablig.append( ligName )
            #linux:
            temp = ligName.split( "/" )
            #windows : 
            temp2 = ligName.split( "\\" )
            if (len(temp2)>len(temp)):
                temp=temp2
            temp = temp[len(temp)-1].split(".")
            self.can.create_text( 100, pas*i + 50, text = temp[0], font = "Arial 9 bold", fill = "black" )
            self.printFP( self.ligs.dico[ligName], 200+self.ligs.sizeFP*2.5 , pas*i +50 )
            #self.can.create_text( 275,pas*i +50, text = self.ligs.dico[ligName], font = "Arial 12 bold", fill = "black")
            i=i+1
    
        
    def onClique( self, event ):
        """ function binded to the clic event and """
        
        widg = event.widget
        
        x = widg.canvasx( event.x )
        y = widg.canvasy( event.y )
        temp =  widg.find_closest( x, y )[0]
                
        if ( len( self.can.gettags( temp ) )!=0 ):
            if ( self.can.gettags( temp )[0]!="current" ):
                Fpno =  self.can.gettags( temp )[0]
                tab = Fpno.split( '_' )
                self.current[0]=int(tab[0])
                self.current[1]=int(tab[1])
                self.pyshow( self.tabAA[int( tab[0] )], self.tablig[int( tab[1] )] )
                temp = [self.tabAA[int( tab[0] )],self.tablig[int( tab[1] )],tab[0],tab[1]]
                self.firevent(temp)
        
        
    def printFP( self, FP, x, y ):
        """print FingerPrints corresponding at the interaction by the apropriate color"""
        
        longueur = 7*self.ligs.sizeFP
                
        i = 0
        nbFP = 0
        for bit in FP: 
            # old version:
            
#            modulo = i%( self.ligs.sizeFP+1 )
#            
#            if modulo == self.ligs.sizeFP:
#            
#                i=i+1
#                self.FPn[0] = self.FPn[0] +1
#                continue
#            toto = None
#            coul = 0
#            if ( bit== '0' ):
#                toto = self.can.create_rectangle( x-longueur/2+modulo*( longueur-10 )/self.ligs.sizeFP+longueur * self.FPn[0], y-5, x-longueur/2+longueur * self.FPn[0]+( 1+modulo )*( longueur-10 )/self.ligs.sizeFP, y+5, width = 1.5 )
#                self.can.itemconfig( toto, tags=( str( self.FPn[0] )+"_"+str( self.FPn[1] ) ) )
#            else:
#                toto = self.can.create_rectangle( x-longueur/2+modulo*( longueur-10 )/self.ligs.sizeFP+longueur * self.FPn[0], y-5, x-( longueur/2 )+longueur * self.FPn[0]+( 1+modulo )*( longueur-10 )/self.ligs.sizeFP, y+5, width = 1.5, fill=self.colors[modulo] )
#                self.can.itemconfig( toto, tags=( str( self.FPn[0] )+"_"+str( self.FPn[1] ) ) )
#            i=i+1
            modulo = i%( self.ligs.sizeFP )
        
            if (modulo == 0 ) and (i>self.ligs.sizeFP-1) :
        
                self.FPn[0] = self.FPn[0] +1
        
            toto = None
            coul = 0
            if ( bit== '0' ):
                toto = self.can.create_rectangle( x-longueur/2+modulo*( longueur-10 )/self.ligs.sizeFP+longueur * self.FPn[0], y-5, x-longueur/2+longueur * self.FPn[0]+( 1+modulo )*( longueur-10 )/self.ligs.sizeFP, y+5, width = 1)
                self.can.itemconfig( toto, tags=( str( self.FPn[0] )+"_"+str( self.FPn[1] ) ) )
            else:
                toto = self.can.create_rectangle( x-longueur/2+modulo*( longueur-10 )/self.ligs.sizeFP+longueur * self.FPn[0], y-5, x-( longueur/2 )+longueur * self.FPn[0]+( 1+modulo )*( longueur-10 )/self.ligs.sizeFP, y+5, width = 1, fill=self.colors[modulo] )
                self.can.itemconfig( toto, tags=( str( self.FPn[0] )+"_"+str( self.FPn[1] ) ) )    

            i=i+1



        self.FPn[1] = self.FPn[1]+1
        self.FPn[0]=0
        self.resizescrollregion()
        
        
    def setCav( self, cavit ):
        """set the cavity (object Cavite)"""
        self.cav = cavit
    
    def setLigs( self, Ligands ):
        """set the ligands (object Ligands)"""
        self.ligs = Ligands
        
    def printSelect(self,x,y):
        monX = X 
        monY = Y
        if (monX>=len(self.tabAA)):
            monX=len(self.tabAA)-1
        if (monY>=len(self.tablig)):
            monY=len(self.tablig)-1
        
        self.pyshow(self.tabAA[int( monX )], self.tablig[int( monY )])
        temp = [self.tabAA[int( monX )],self.tablig[int( monY )],tab[0],tab[1]]
        self.firevent(temp)
        
    def update(self,event):
        
        if (event[0]>=len (self.tabAA)):
            event[0]=len(self.tabAA)-1 
        if (event[1]>=len (self.tablig)):
            event[1]=len(self.tablig)-1            
        self.pyshow(self.tabAA[int( event[0])], self.tablig[int( event[1] )])
        temp = [self.tabAA[int( event[0])], self.tablig[int( event[1] )],event[0],event[1]]
        self.firevent(temp)
#        self.printSelect(event[0],event[1])
    
    def pyCav( self ):
        """print in pymol viewer the cavity"""
        cmd.load( self.cav.cav, "cav" )
        cmd.hide( "all" )
        cmd.show( "cartoon", "cav" )
        cmd.color( "gray", "n. CA " )

        
    def pyshow( self, resn, lign ):
        """print in pymol viewer the ligand and the residu selected"""
        
        cmd.hide( "all" )
        cmd.show( "cartoon", "cav" )
        cmd.color("green","e. C")
        cmd.color("blue", "e. N")
        cmd.color("red", "e. O")
        
        cmd.color( "gray", "n. CA" )
        cmd.delete( "myRes" )
        cmd.select( "myRes", "r. "+ self.cav.dico[resn][0]+" and i. "+self.cav.dico[resn][1] )
        cmd.show( "sticks", "myRes and !h." )
        cmd.show("nb_sphere","myRes and hetatm and !h.")
        cmd.show("sticks","myRes and hetatm and h.")
        
        cmd.delete( "lig" )
        cmd.load( lign, "lig" )
        cmd.hide("lines","lig")
        cmd.color("yellow","lig and e. c")
        cmd.color("blue", "lig and e. N")
        cmd.color("red", "lig and e. O")
        cmd.show( "sticks", "lig and !h." )
        cmd.delete("hb")
        cmd.dist("hb","lig and (e. N or e. O)","myRes and (e. N or e. O)","3.2" )
        
        cmd.zoom( complete= 1 )
        #cmd.zoom( "myRes or lig" )
        cmd.zoom()
        
    def addlistener(self,listener):
        self.listener.append(listener)
    
    def firevent(self,event):
        for listener in self.listener:
            listener.update(event)