#!/usr/local/bin/python2.5

from PIL import Image,ImageDraw,ImageFont
from cavite import Cavite
from ligands import Ligands
from Tkinter import Frame,Scale,IntVar,Canvas,Label,Button,DoubleVar,Entry , StringVar , Listbox
from Pmw import ScrolledCanvas
import threading
import sys

import tkColorChooser



class Listener : 
	def update(self):
		pass
		#print "update"
	

class Changeable :
	def __init__ (self):
		self.list = []
	
	def addListener(self,listener):
		self.list.append(listener)
	
	def fireEvent(self,e):
		for listener in self.list:
			listener.update(e)
			

class Event :
	def __init__ ( self):
		self.value = ""


class scaleEvent (Event) :
	def __init__ (self, topOff, leftOff,hFP,wFP,ecartVFP,ecartHFP):
		self.value = "scale"
		self.topOff = topOff
		self.leftOff = leftOff
		self.hFP = hFP
		self.wFP=wFP
		self.ecartVFP = ecartVFP
        	self.ecartHFP = ecartHFP
		
		
class saveEvent(Event):
	def __init__(self):
		self.value = "save"
		
class colorEvent(Event):
	def __init__(self,ind,col):
		self.value = "color"
		self.index = ind
		self.color = col
		
class Main (Listener): 
	def __init__(self,pdbFile , ligFile, FPFile,sizeFP):
		
		self.topOff=20
		self.leftOff=20
		self.hFP=10
		self.wFP=70
		
		
	        self.ecartVFP = 30
        	self.ecartHFP = 80
		
		
			
		self.prCan = printCanva(pdbFile,ligFile,FPFile,sizeFP)
        	info =  "there is "+str(len(self.prCan.cav.cavord))+" amino acide\n"+\
        		"there is "+str(len(self.prCan.lig.tablig))+ " ligands\n"+\
        		"size of the fingerPrint "+str(self.prCan.lig.sizeFP)
		self.colors = [ 'blue',\
			self.prCan.rvb(50,205,50),\
			self.prCan.rvb(152,251,152),\
			self.prCan.rvb(205,0,0),\
			self.prCan.rvb(240,128,128),\
			'yellow',\
			self.prCan.rvb(205,205,0),\
			self.prCan.rvb( 255, 150, 150 ),\
			self.prCan.rvb( 255, 150, 150 ),\
			'cyan',\
			'magenta' ]
        	self.prMan = printManager()
		self.prMan.can.interior().configure(bg = "white",height = 200, width = 200)
        	self.prMan.addListener(self)
        	self.prMan.master.title("Parameters")
        	self.printRec()
        	#self.prMan.info.configure(text=info)
        	self.prMan.mainloop()
		
	def printRec(self) : 
        	can = self.prMan.can.interior()
        	can.configure(bg = "white",height = 500, width = 500)
        	can.create_rectangle(0,0,600,600,fill = "white")
		can.create_text( (self.leftOff+self.ecartHFP/2+40 ,self.topOff/2), anchor="n",text="AA100")
		
		can.create_text( (self.leftOff+self.ecartHFP*3/2 +40,self.topOff/2), anchor="n",text="AA200")
		
		#can.create_rectangle(self.leftOff/2 ,self.topOff+self.ecartVFP/2-6,self.leftOff/2+50 ,self.topOff+self.ecartVFP/2+6)
		can.create_text( (self.leftOff/2 +25,self.topOff+self.ecartVFP/2 ),text="ligand1")
		can.create_text( (self.leftOff/2 +25,self.topOff+self.ecartVFP*3/2 ),text="ligand2")
        	can.create_rectangle(self.leftOff+self.ecartHFP/2-self.wFP/2+40,\
			self.topOff+self.ecartVFP/2-self.hFP/2,\
			self.leftOff+self.ecartHFP/2+self.wFP/2+40,\
			self.topOff+self.ecartVFP/2+self.hFP/2,\
			fill = "yellow")
		can.create_rectangle(self.leftOff+self.ecartHFP/2-self.wFP/2+40,\
			self.topOff+self.ecartVFP*3/2-self.hFP/2,\
			self.leftOff+self.ecartHFP/2+self.wFP/2+40,\
			self.topOff+self.ecartVFP*3/2+self.hFP/2,\
			fill = "yellow")
		can.create_rectangle(self.leftOff+self.ecartHFP*3/2-self.wFP/2+40,\
			self.topOff+self.ecartVFP/2-self.hFP/2,\
			self.leftOff+self.ecartHFP*3/2+self.wFP/2+40,\
			self.topOff+self.ecartVFP/2+self.hFP/2,\
			fill = "yellow")
		can.create_rectangle(self.leftOff+self.ecartHFP*3/2-self.wFP/2+40,\
			self.topOff+self.ecartVFP*3/2-self.hFP/2,\
			self.leftOff+self.ecartHFP*3/2+self.wFP/2+40,\
			self.topOff+self.ecartVFP*3/2+self.hFP/2,\
			fill = "yellow")
        	 
		
	def update (self,e) :
        	if e.value == "scale":
        		can = self.prMan.can.interior()
            		#self.topOff = can.canvasy(e.topOff)
			self.topOff = e.topOff
            		#self.leftOff = can.canvasx(e.leftOff)
			self.leftOff = e.leftOff
            		self.hFP = e.hFP
			self.wFP=e.wFP
			self.ecartVFP = e.ecartVFP
        		self.ecartHFP = e.ecartHFP
			
            		self.printRec()
			
        	if e.value == "save":
        		self.printImg()
					
        	if e.value == "color":
        		
        		#self.colors = self.colors[0:e.index]+e.color+self.colors[e.index+1:]
        		self.colors[int(e.index)] = e.color

	def printImg(self):
        	im = Image.new("RGB",(500,500),"white")
		
        	draw =  ImageDraw.Draw(im)
		#fontSize = self.fontSize.var.get()
        	self.font = ImageFont.truetype("/opt/pymolFP/Georgia.ttf",int(self.prMan.fontSizevar.get())) 
        	count = 0
		ligcount=0
		ligSize = 0
		FPcount = 0
		for lig in self.prCan.lig.tablig:
			if ligSize < draw.textsize(lig,font=self.font)[0]:
				ligSize = draw.textsize(lig,font=self.font)[0]
		im = Image.new("RGB",(len(self.prCan.cav.cavord)*self.ecartHFP+self.leftOff*2+ligSize,len(self.prCan.lig.tablig)*self.ecartVFP+self.topOff*2),"white")
        	draw =  ImageDraw.Draw(im)
		for lig in self.prCan.lig.tablig:
			#draw.line((10,self.topOff+(self.ecartVFP)/2*(2*ligcount+1),400,self.topOff+(self.ecartVFP)/2*(2*ligcount+1)),fill=1)
			draw.text((self.leftOff/2,\
				self.topOff+(self.ecartVFP)/2*(2*ligcount+1)-draw.textsize(lig,font=self.font)[1]/2),\
				text = lig,\
				font=self.font,\
				fill = "black"\
				
				)
			
			ligcount=ligcount+1
			
        	for AA in self.prCan.cav.cavord:
			textSize = draw.textsize(AA,font=self.font)[0]
			#draw.line((self.leftOff+(self.ecartHFP)/2*(2*count+1)+ligSize,5,self.leftOff+(self.ecartHFP)/2*(2*count+1)+ligSize,100),fill =1)
        		draw.text((self.leftOff+(self.ecartHFP)/2*(2*count+1)+ligSize -textSize/2,\
				self.topOff/2),\
				text = AA,\
				font=self.font,\
				fill = "black")
			
			count = count +1
		#print "ecartVFP"+str(self.ecartVFP)
			
		ligcount=0
		for FP in self.prCan.lig.tabFP:
			
			
			nbLig = len(self.prCan.lig.tablig)
			nbAA = len(self.prCan.cav.cavord)
			posRaw = 0
			for i in range(len(FP)):
				
				modulo =  i % self.prCan.lig.sizeFP
				posRaw = (i-modulo)/self.prCan.lig.sizeFP
				if FP[i] == "1":
					color = self.colors[modulo]
					
				else:
					color = "white"
				
				
				draw.rectangle((self.leftOff+(2*posRaw +1) * (self.ecartHFP)/2+ligSize-self.wFP/2+modulo*self.wFP/self.prCan.lig.sizeFP,\
					self.topOff+(2*FPcount+1) * (self.ecartVFP)/2 -self.hFP/2, \
                			self.leftOff+(2*posRaw+1) * (self.ecartHFP)/2+ligSize-self.wFP/2+(modulo+1)*self.wFP/self.prCan.lig.sizeFP,\
					self.topOff +(2*FPcount +1) * (self.ecartVFP)/2 +self.hFP/2),\
                			fill = color,outline ="black")
					
				
			#print str(self.ecartVFP)	
			FPcount= FPcount+1
				
            		
		
		
		
        	im.show("test","display")
	

		
		 		


	
class printCanva :
	def __init__(self,cavFile,ligFile,fpFile,fpLength):
		
		
		self.cav=Cavite(cavFile)
		self.lig=Ligands(self.parse(ligFile),self.parse(fpFile),fpLength)
		
		


        def parse(self,file):
        	fic=open(file,'r')
        	res=[]
        	while (1):
        		line=fic.readline()
            		line.strip('\n')
            		if ((line=="")or (line=="\n")):
                		break
            		line =  line[0:len(line)-1]
            		res.append(line)
        
        	return res
        
	def rvb( self, r, v, b ):
       		""" a little function that creat a rgv color"""
        	return "#%02x%02x%02x" % ( int( r ), int( v ), int( b ) )
	
	
	
		
		
class printManager(Frame,Changeable):

	
	def __init__(self, master=None):
		Changeable.__init__(self)
        	Frame.__init__(self, master)
					
		self.colors = [ 'blue',\
			self.rvb(50,205,50),\
			self.rvb(152,251,152),\
			self.rvb(205,0,0),\
			self.rvb(240,128,128),\
			'yellow',\
			self.rvb(205,205,0),\
			self.rvb( 255, 150, 150 ),\
			self.rvb( 255, 150, 150 ),\
			'cyan',\
			'magenta' ]
		self.FPSize = int(sys.argv[4])
		self.grid()
		self.scal1val = DoubleVar()
		self.scal2val = DoubleVar()
		self.scal3val = DoubleVar()
		self.scal4val = DoubleVar()
		self.scal5val = DoubleVar()
		self.scal6val = DoubleVar() 
		self.fontSizevar = StringVar()		

		self.scal1 = Scale(master,relief = "groove",width=25,label = "size of the top border",orient="vertical",command = self.scalCommande,variable = self.scal1val)
		self.scal2 = Scale(master,relief ="groove",width=25,label = "size of the left border",orient="horizontal",command = self.scalCommande,variable = self.scal2val)
		self.scal3 = Scale(master,relief ="groove",width=25,label = "height of the FP",orient="vertical",command = self.scalCommande,variable = self.scal3val,to = 30,resolution = 0.2)
		self.scal4 = Scale(master,relief ="groove",width=25,label = "width of the FP",orient="horizontal",command = self.scalCommande,variable = self.scal4val)
		self.scal5 = Scale(master,relief ="groove",width=25,label = "vertical distance between FP",orient="vertical",command = self.scalCommande,variable = self.scal5val)
		self.scal6 = Scale(master,length=200,relief ="groove",width=25,label = "Horizontal distance between FP",orient="horizontal",command = self.scalCommande,variable = self.scal6val)
		self.fontSize = Entry(master ,width=4,textvariable=self.fontSizevar)
		self.scal1.set(20)
		self.scal2.set(20)
		self.scal3.set(10)
		self.scal4.set(70)
		self.scal5.set(30)
        	self.scal6.set(80)
		self.fontSizevar.set("10")
		
		self.scal1.grid(row=1,column=0,sticky="WENS")
		self.scal2.grid(row=0,column=1,sticky="WENS")
		self.scal3.grid(row=2,column=0,sticky="WENS")
		self.scal4.grid(row=0,column=2,sticky="WENS")
		self.scal5.grid(row=3,column=0,sticky="WENS")
		self.scal6.grid(row=0,column=3,sticky="WENS")
		self.save = Button(master,text="save",command = self.save)
		self.save.grid(row=0,column=0,sticky="WENS")
		self.fontSize.grid(row=4,column=0,sticky="WENS")
		self.color = Button(master,text="set color ",command = self.setColor)
		self.color.grid(row=3,column=2,sticky="WENS")
		self.listColor = Listbox(master,selectmode="SINGLE",height = self.FPSize,width = 3);
		for i in range (self.FPSize):
			self.listColor.insert("end",i+1)
		
		self.listColor.grid(row=3,column=3)
		
		self.can = ScrolledCanvas(master)
		self.can.grid(row=1,column=1,columnspan=3,rowspan=2,sticky="WENS")
	
	def scalCommande(self,toto):
		
		e = scaleEvent (self.scal1val.get(),self.scal2val.get(),self.scal3val.get(),self.scal4val.get(),self.scal5val.get(),self.scal6val.get())
		self.fireEvent(e)

	def save(self):
		e = saveEvent()
		self.fireEvent(e)
		
	def setColor(self):
		
		
		
		sel =  self.listColor.curselection()
		res =  tkColorChooser.askcolor(color = self.colors[int(sel[0])])
		e = colorEvent(sel[0], self.rvb(res[0][0],res[0][1],res[0][2]))
		self.colors[int(sel[0])]=self.rvb(res[0][0],res[0][1],res[0][2])
		self.color.configure(highlightbackground = self.rvb(res[0][0],res[0][1],res[0][2]))
		self.fireEvent(e)
		
	def rvb( self, r, v, b ):
       		""" a little function that creat a rgv color"""
        	return "#%02x%02x%02x" % ( int( r ), int( v ), int( b ) )
		
class mainThread(threading.Thread):
	 
	def __init__(self):
		#print "initialise"
		threading.Thread.__init__(self)
		self.fen = printManager()
		self.fen.master.title("Parameters")
		
	def run(self):
		#print "je suis dans la boucle"
		
		self.fen.mainloop()
		
		
if (len (sys.argv) !=5):
	print "Usage: "+sys.argv[0]+" [fileof the cavity] [file that contains the list of ligands] [file of Fingerprint] [size 7-11]"
else:
	Main(sys.argv[1],sys.argv[2],sys.argv[3],int(sys.argv[4]))

