/*
 *
 * input.h
 * Created: 20081229 Jerome Hert
 *  
 */
 
#ifndef __INPUT__
#define __INPUT__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "constant.h"
#include "geom3d.h"
#include "protein.h"
#include "align.h"

/*
 * +--------------------------------------------------------------------------+
 * | PROTOTYPES                                                               |
 * +--------------------------------------------------------------------------+
 */

char* substr(const char* string, size_t begin, size_t len);

int		input_is_comment(	char *line);
void	input_process_line(	char *line, t_protein *protein);
void	input_print(		FILE *fh, t_protein *protein);
void	input_read_residues(t_protein *protein);
void	input_print_residues(FILE *fh, t_protein *protein);
void	input_read_protein(	t_protein *protein);

void	output_print_score(		FILE *fh,	t_protein *protein, t_alignment *alignment);
void	output_print_transfo(	FILE *fh,	t_point *center, t_transfo *transfo);
void	output_print_dist_local(FILE *fh,	t_protein  *protein1, t_alignment *alignment1, t_protein *protein2, t_alignment *alignment2);
void	output_print_map(		FILE *fh,	t_protein  *protein1, t_fp *map1, t_protein *protein2, t_fp *map2);
void	align_protein_file(	char *infile, char *outfile, t_transfo *transfo, t_point *center);

#endif
