#include <iostream>
#include <iomanip>
#include <ostream>
#include <fstream>
#include <string>
#include <cmath> 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <algorithm>
#include <vector>
#include <map>


using namespace std;

void Tokenize( const string& str, vector<string>& tokens, const string& delimiters)
{
    // Skip delimiters at beginning.
    string::size_type lastPos = str.find_first_not_of(delimiters, 0);
    // Find first "non-delimiter".
    string::size_type pos     = str.find_first_of(delimiters, lastPos);

    while (string::npos != pos || string::npos != lastPos)
    {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delimiters.  Note the "not_of"
        lastPos = str.find_first_not_of(delimiters, pos);
        // Find next "non-delimiter"
        pos = str.find_first_of(delimiters, lastPos);
    }
}
double min (double a , double b){
	if (a<b) return a;
	return b;
}


double dist(vector<int>& a , vector<int>& b){
	double res = 0;
	double countA = 0;
	double countB = 0;
	for (int i = 0 ; i< a.size(); i++){
		if (a[i]==b[i] && a[i] != 0) res++;
		if (a[i]!=0) countA++;
		if (b[i]!=0) countB++;
		
	}
	double mymin = min(countA,countB);
	if (mymin == 0) return 0;
	res = res /mymin ;
	return res;
}
int main(int argc, char* argv[]){
	ifstream in(argv[1]);
	string line;
	map<string,vector<int> > FPs;
	vector<string> bit; 
	vector <int> fp;
	vector<string> temp;
	while (!in.eof()){
		bit.clear();
		fp.clear();
		temp.clear();
		getline(in,line);
		
		string name;
		Tokenize( line,temp," :_");
		
		if (line.length() != 0){
			name = temp[0];
			line = temp[temp.size()-1];
			
			
		
			Tokenize(line,bit,";");
			for (int i = 0 ; i<bit.size(); i++){
			
				fp.push_back(atoi(bit[i].c_str()));
				
			}
			FPs.insert(pair<string, vector<int> >(name,fp));
		}
		
		
		
	}
	
	ifstream in2(argv[2]);
	while (!in2.eof()){
		getline(in2,line);
		if (line.length() != 0){
			vector <string> comp;
			Tokenize(line,comp," \t");
			cout<<comp[0]<<"\t"<<comp[1]<<"\t"<<dist(FPs[comp[0]],FPs[comp[1]])<<endl;;
		}
		
	}
	
	return 0;
}
