#!/usr/bin/perl

use strict;
local $| =1;
open (FIC,$ARGV[0]) or die ("impossible d'ouvrire $ARGV[0]"); #list de paire
my @pairs;
my %list;
my $c = 0;
while (<FIC>){
	chomp;
	my @tab = split(/\s+/);
	my @temp = ($tab[0],$tab[1]);
	unshift(@pairs,\@temp);
	$list{$tab[0]} = 1;
	$list{$tab[1]} = 1; 
}



close FIC;
my %hashFP;
open (FPS, $ARGV[1]) or die ("impossible d'ouvrire $ARGV[1]");
while (<FPS>){
	chomp;
	my @tab = split (/\s+/);
	$tab [0] =~ s/_.*//;
	$hashFP{$tab[0]}=$tab[2] if (defined($list{$tab[0]}));
	
	
}
print "PDB1\tPDB2\tham2\tham3\n";
#~ print "PDB1\tPDB2\tham2\n";
foreach my $temp (@pairs){
	my $pair = $temp;
	print $pair->[0]."\t".$pair->[1]."\t";
	
	#~ my $tani = tani($hashFP{$pair->[0]},$hashFP{$pair->[1]});
	#~ my $eucl = eucl($hashFP{$pair->[0]},$hashFP{$pair->[1]});
	#~ my $ham = hamming($hashFP{$pair->[0]},$hashFP{$pair->[1]});
	my $ham2 = hamming2($hashFP{$pair->[0]},$hashFP{$pair->[1]});
	my $ham3 = hamming3($hashFP{$pair->[0]},$hashFP{$pair->[1]});
	#my $tver95 = tversky($hashFP{$pair->[0]},$hashFP{$pair->[1]},0.95,0.05);
	#my $tver75 = tversky($hashFP{$pair->[0]},$hashFP{$pair->[1]},0.75,0.25);
	#my $tver50 = tversky($hashFP{$pair->[0]},$hashFP{$pair->[1]},0.5,0.5);
	#my $tver25 = tversky($hashFP{$pair->[0]},$hashFP{$pair->[1]},0.25,0.75);
	print "$ham2\t$ham3\n";
	#~ print $ham."\t".$ham2."\n";
}



sub tani{
	my $f1 = $_[0];
	my $f2 = $_[1];
	my $res = 0;
	my @fp1 = split (/;/,$f1);
	my @fp2 = split (/;/,$f2);
	my $s1 = 0;
	my $s2 = 0;
	my $s3 = 0;
	for(my $i = 0; $i <= $#fp1 ; $i++){
		$s1 += $fp1[$i]*$fp2[$i];
		$s2 += $fp1[$i]*$fp1[$i];
		$s3 += $fp2[$i]*$fp2[$i];
	}
	if (($s2+$s3 -$s1)>0){
		$res = $s1/($s2+$s3 -$s1);
	}
	return $res; 
}

sub eucl {
	
	my $f1 = $_[0];
	my $f2 = $_[1];
	my $res = 0;
	my @fp1 = split (/;/,$f1);
	my @fp2 = split (/;/,$f2);
	
	for(my $i = 0; $i <= $#fp1 ; $i++){
		$res += ($fp1[$i]*$fp2[$i])**2;
	}
	$res = sqrt($res);
	return $res;
}

sub hamming{
	# compte le nombre de bit differents
	my $f1 = $_[0];
	my $f2 = $_[1];
	my $res = 0;
	my @fp1 = split (/;/,$f1);
	my @fp2 = split (/;/,$f2);
	
	for(my $i = 0; $i <= $#fp1 ; $i++){
		if ($fp1[$i] != $fp2[$i]){
			$res++
		}
	}
	
	
	return $res;

}
sub hamming2{
	# compte le nombre de bit alum en commun ou compte le nombre de compte identique 
	my $f1 = $_[0];
	my $f2 = $_[1];
	my $res = 0;
	my @fp1 = split (/;/,$f1);
	my @fp2 = split (/;/,$f2);
	
	for(my $i = 0; $i <= $#fp1 ; $i++){
		if ($fp1[$i] ==  $fp2[$i] && $fp1[$i]!= 0){
			#~ print $fp1[$i]."\t".$fp2[$i]."\t$i",$/;
			$res++;
		}
	}
	
	
	return $res;

}

sub hamming3{
	# compte le nombre de bit alum en commun ou compte le nombre de compte identique 
	#normalis
	my $f1 = $_[0];
	my $f2 = $_[1];
	my $res = 0;
	my @fp1 = split (/;/,$f1);
	my @fp2 = split (/;/,$f2);
	my $count1;
	my $count2;
	for(my $i = 0; $i <= $#fp1 ; $i++){
		if ($fp1[$i] ==  $fp2[$i] && $fp1[$i]!= 0){
			#~ print $fp1[$i]."\t".$fp2[$i]."\t$i",$/;
			$res++;
		}
		
		$count1++ if ($fp1[$i]!=0 );
		$count2++ if ($fp2[$i]!=0 );
	}
	
	my $min = min($count1,$count2);
	#~ print $count1,"\t",$count2,"\t",$min,$/;
	if ($min == 0) { return 0;} 
	return $res/$min;

}
sub tversky{
	my $f1 = $_[0];
	my $f2 = $_[1];
	my $alpha = $_[2];
	my $beta = $_[3];
	my $res = 0;
	my @fp1 = split (/;/,$f1);
	my @fp2 = split (/;/,$f2);
	my $s1 = 0;
	my $s2 = 0;
	my $s3 = 0;
	for(my $i = 0; $i <= $#fp1 ; $i++){
		$s1 += $fp1[$i]*$fp2[$i];
		$s2 += $fp1[$i]*$fp1[$i] - $fp1[$i]*$fp2[$i];
		$s3 += $fp2[$i]*$fp2[$i] - $fp1[$i]*$fp2[$i];
	}
	if ($alpha*$s2+$beta*$s3 +$s1>0){
		$res = $s1/($alpha*$s2+$beta*$s3 +$s1);
	}
	return $res; 
	
}
sub max{
	
	return $_[1] if ($_[1]>$_[2]);
	return $_[2];
}
sub min{
	return $_[0] if ($_[0]<$_[1]);
	return $_[1];
}