#!/usr/bin/perl
use strict;

if (scalar @ARGV != 1){
	print "usage : ./CaTagger.pl protein.mol2 > Protein-CA.mol2\n";
	exit 1;
	
}
my $mol2file = $ARGV[0];

#variable de formatage
my ($at1,$at2,$at3,$at4,$at5,$at6,$at7,$at8,$at9,$at10);



open (MOL2,$mol2file) or die "impossible d'ouvrire $mol2file";

my $atFlag = 0;
my $CAcounter = 0;
my @tabCa;
while (<MOL2>){
	
	if (/@<TRIPOS>BOND/){
		$atFlag = 0;
	}
	if ($atFlag){
		my @tab = split (/\s+/);
		if (
			($tab[2] eq "CA" && (
				$tab[8]=~ /^ALA/
				|| $tab[8]=~ /^ARG/
				|| $tab[8]=~ /^ASN/
				|| $tab[8]=~ /^ASP/
			
				|| $tab[8]=~ /^CYS/
				
				|| $tab[8]=~ /^GLN/
				|| $tab[8]=~ /^GLU/
				|| $tab[8]=~ /^GLY/
				|| $tab[8]=~ /^HID/
				|| $tab[8]=~ /^HIE/
				|| $tab[8]=~ /^HIS/
				|| $tab[8]=~ /^ILE/
				|| $tab[8]=~ /^LEU/
				|| $tab[8]=~ /^LYS/
				|| $tab[8]=~ /^MET/
				
				|| $tab[8]=~ /^PHE/
				|| $tab[8]=~ /^PRO/
				|| $tab[8]=~ /^SER/
				|| $tab[8]=~ /^THR/
				|| $tab[8]=~ /^TRP/
				|| $tab[8]=~ /^TYR/
				|| $tab[8]=~ /^VAL/
				
				)&&$tab[6]  =~ /C\.3/
			)||(
				(
					$tab[2] eq "MN" ||
					$tab[2] eq "FE" ||
					$tab[2] eq "MG" ||
					$tab[2] eq "CO" ||
					$tab[2] eq "ZN" ||
					$tab[2] eq "NI" ||
					$tab[2] eq "CU" ||
					$tab[2] eq "CD" ||
					$tab[2] eq "CA"
				)
				&& $tab[6]  !~ /C\./
			)
		) 
			
		{
			$tab[9]=40.0000;
			$CAcounter++;
			unshift (@tabCa,$tab[1]);
		}else {
			$tab[9]=0.0000;
		}
		shift @tab;
		($at1,$at2,$at3,$at4,$at5,$at6,$at7,$at8,$at9,$at10) = @tab;
		$~ = "atom";
		write;
	}else {print;}
	if (/@<TRIPOS>SET/){
		print "HS              STATIC     ATOMS    <user>   **** Hot spots\n";
		print $CAcounter."\t".join(" ",@tabCa)."\n";
		
	}
	if (/@<TRIPOS>ATOM/){
		$atFlag = 1;
	}
	
	
}

format atom = 
@>>>>>> @<<<<<<  @###.#### @###.####  @###.#### @<<<<   @>> @<<<<<<<  @##.#### @<<<<<<<<<<<<<<<<<<<<<<<<
$at1,$at2,$at3,$at4,$at5,$at6,$at7,$at8,$at9,$at10
.


