package data;

import java.text.DecimalFormat;

public class Triangle {

	private double dist1, dist2,dist3;
	private String prop1, prop2,prop3;
	private Atom at1, at2, at3;
	
	
	public Triangle(double dist1, double dist2, double dist3, String prop1, String prop2, String prop3, Atom at1, Atom at2, Atom at3) {
		super();
		this.dist1 = dist1;
		this.dist2 = dist2;
		this.dist3 = dist3;
		this.prop1 = prop1;
		this.prop2 = prop2;
		this.prop3 = prop3;
		this.at1 = at1;
		this.at2 = at2;
		this.at3 = at3;
	}

	public Triangle(double dist1, double dist2, double dist3, String prop1, String prop2, String prop3) {
		super();
		this.dist1 = dist1;
		this.dist2 = dist2;
		this.dist3 = dist3;
		this.prop1 = prop1;
		this.prop2 = prop2;
		this.prop3 = prop3;
		
	}

	public double getDist1() {
		return dist1;
	}

	public void setDist1(double dist1) {
		this.dist1 = dist1;
	}

	public double getDist2() {
		return dist2;
	}

	public void setDist2(double dist2) {
		this.dist2 = dist2;
	}

	public double getDist3() {
		return dist3;
	}

	public void setDist3(double dist3) {
		this.dist3 = dist3;
	}

	public String getProp1() {
		return prop1;
	}

	public void setProp1(String prop1) {
		this.prop1 = prop1;
	}

	public String getProp2() {
		return prop2;
	}

	public void setProp2(String prop2) {
		this.prop2 = prop2;
	}

	public String getProp3() {
		return prop3;
	}

	public void setProp3(String prop3) {
		this.prop3 = prop3;
	}

	public Triangle() {
		// TODO Auto-generated constructor stub
	}

	public String toString(){
		DecimalFormat nf = new DecimalFormat();
		nf.setMinimumFractionDigits(2);
		nf.setMaximumFractionDigits(2);
		String res ="";
		res  = "            "+this.prop1+"\t"+at1.getName()+";"+at1.getResiduName()+at1.getResID()+"\n";
		res += "    "+nf.format(this.dist1)+" /   \\ "+nf.format(this.dist2)+"\n";
		res += "        "+this.prop3+" "+at3.getName()+";"+at3.getResiduName()+at3.getResID()+" --- "+this.prop2+" "+at2.getName()+";"+at2.getResiduName()+at2.getResID()+"\n";
		res += "           "+nf.format(this.dist3)+"\n";
		return res;
	}
	
	
}
