package data;

import java.util.ArrayList;

public class Atom {

	private double  x,y,z;
	private int ID;
	private String name,type,residuName,resID;
	private ArrayList<String> properties = new ArrayList<String>();
	private boolean isOXTres = false;
	
	public ArrayList<String> getProperties() {
		return properties;
	}

	public void setProperties(ArrayList<String> properties) {
		this.properties = properties;
	}

	public Atom(double x, double y, double z, int id, String name, String type, String residuName, String resID) {
		super();
		this.x = x;
		this.y = y;
		this.z = z;
		this.ID = id;
		this.name = name;
		this.type = type;
		this.residuName = residuName;
		this.resID = resID;
		
	}

	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}

	public String getResiduName() {
		return residuName;
	}

	public void setResiduName(String residuName) {
		this.residuName = residuName;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public double getX() {
		return x;
	}

	public void setX(double x) {
		this.x = x;
	}

	public double getY() {
		return y;
	}

	public void setY(double y) {
		this.y = y;
	}

	public double getZ() {
		return z;
	}

	public void setZ(double z) {
		this.z = z;
	}

	public Atom() {
		// TODO Auto-generated constructor stub
	}

	

	public int getID() {
		return ID;
	}

	public void setID(int id) {
		ID = id;
	}

	public String getResID() {
		return resID;
	}

	public void setResID(String resID) {
		this.resID = resID;
	}
	public String toString (){
		String res ="";
		res =  this.getName() +";"
			+ this.getID() +";"
			+ this.getResID() + ";" 
			+ this.getResiduName() +";"
			+ this.getType() +";"
			+ this.getX() + ";"
			+ this.getY() + ";"
			+ this.getZ()+ ";"
			+ this.getProperties();
		return res;
	}

	public boolean isOXTres() {
		return isOXTres;
	}

	public void setOXTres(boolean isOXTres) {
		this.isOXTres = isOXTres;
	}

}
