/*
 * Decompiled with CFR 0.152.
 */
package main;

import data.Atom;
import data.FPFactory;
import data.FingerPrint;
import data.Triangle;
import data.TriangleFactory;
import io.Mol2Reader;
import io.PharmacophoreDefReader;
import io.PropertiesBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import utils.NotDefException;

public class Main {
    public static void main(String[] args) {
        double debut = System.nanoTime();
        Hashtable<String, String> arguments = Main.parseArgs(args);
        String defProp = arguments.get("defProp");
        String defTri = arguments.get("defTri");
        String out = arguments.get("out");
        try {
            PropertiesBuilder pb = new PropertiesBuilder(defProp);
            PharmacophoreDefReader pdr = new PharmacophoreDefReader(defTri);
            BufferedWriter bwStat = null;
            if (arguments.containsKey("stat")) {
                FileWriter stat = new FileWriter(arguments.get("stat"));
                bwStat = new BufferedWriter(stat);
            }
            FileWriter fw = new FileWriter(out);
            BufferedWriter bw = new BufferedWriter(fw);
            FPFactory fpf = new FPFactory(pdr, arguments.get("mode"));
            if (arguments.containsKey("in")) {
                Mol2Reader mr = new Mol2Reader(arguments.get("in"));
                ArrayList<Atom> atList = mr.getListAt();
                int i = 0;
                while (i < atList.size()) {
                    Atom at = atList.get(i);
                    at.setProperties(pb.assignProp(at));
                    atList.set(i, at);
                    ++i;
                }
                ArrayList<Triangle> listTri = new ArrayList<Triangle>();
                TriangleFactory tf = new TriangleFactory(bwStat);
                int i2 = 0;
                while (i2 < atList.size()) {
                    int j = i2 + 1;
                    while (j < atList.size()) {
                        int k = j + 1;
                        while (k < atList.size()) {
                            listTri.addAll(tf.buildTriangle(atList.get(i2), atList.get(j), atList.get(k)));
                            ++k;
                        }
                        ++j;
                    }
                    ++i2;
                }
                System.out.println("triangles g\u00e9n\u00e9r\u00e9 " + ((double)System.nanoTime() - debut) / Math.pow(10.0, 9.0));
                FingerPrint fp = fpf.computeFp(listTri);
                System.out.println("Fingerprint gen\u00e9r\u00e9 " + ((double)System.nanoTime() - debut) / Math.pow(10.0, 9.0));
                System.out.print(fp);
                System.out.println(" in " + mr.getName());
                fw.write(String.valueOf(mr.getName()) + " : " + fp.getFp() + "\n");
            } else {
                FileReader fr = new FileReader(arguments.get("list"));
                BufferedReader br = new BufferedReader(fr);
                String line = "";
                while ((line = br.readLine()) != null) {
                    if (line.trim().matches("^\\s*$")) continue;
                    Mol2Reader mr = new Mol2Reader(line.trim());
                    ArrayList<Atom> atList = mr.getListAt();
                    int i = 0;
                    while (i < atList.size()) {
                        Atom at = atList.get(i);
                        at.setProperties(pb.assignProp(at));
                        atList.set(i, at);
                        ++i;
                    }
                    ArrayList<Triangle> listTri = new ArrayList<Triangle>();
                    TriangleFactory tf = new TriangleFactory(bwStat);
                    int i3 = 0;
                    while (i3 < atList.size()) {
                        int j = i3 + 1;
                        while (j < atList.size()) {
                            int k = j + 1;
                            while (k < atList.size()) {
                                listTri.addAll(tf.buildTriangle(atList.get(i3), atList.get(j), atList.get(k)));
                                ++k;
                            }
                            ++j;
                        }
                        ++i3;
                    }
                    FingerPrint fp = fpf.computeFp(listTri);
                    System.out.print(fp);
                    System.out.println(" in " + mr.getName());
                    fw.write(String.valueOf(mr.getName()) + " : " + fp.getFp() + "\n");
                }
            }
            fw.close();
            bw.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (NotDefException e) {
            System.err.println(e.myCause());
            e.printStackTrace();
        }
        System.out.println(((double)System.nanoTime() - debut) / Math.pow(10.0, 9.0));
    }

    private static void printUsage() {
        System.err.println("Generate fingerprint of Cavity using 3-point pharamcophores.");
        System.err.println("************************************************************");
        System.err.println("");
        System.err.println("             Written by Nathanael Weill");
        System.err.println("");
        System.err.println("************************************************************");
        System.err.println("Usage:");
        System.err.println("\t-d [file] = Definition of properties per Residus (tableDef.txt)");
        System.err.println("\t-t [file] = definition of triangle (distances intervals + properties to use)");
        System.err.println("\tmode 1 : -i [file] = mol2 file containing HS annotations.");
        System.err.println("\tmode 2 : -l [file] = file containing a list of mol2 file.");
        System.err.println("\t-o [file] = file containing fingerprint(s)");
        System.err.println("\t-s [file] = file containing all distances computed (optional)");
        System.err.println("FLAGS:");
        System.err.println("\t-c : set fingerprint as counts instaead of binary (default binary)");
    }

    private static Hashtable<String, String> parseArgs(String[] args) {
        Hashtable<String, String> res = new Hashtable<String, String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-d")) {
                res.put("defProp", args[i + 1]);
            }
            if (args[i].equals("-t")) {
                res.put("defTri", args[i + 1]);
            }
            if (args[i].equals("-o")) {
                res.put("out", args[i + 1]);
            }
            if (args[i].equals("-i")) {
                res.put("in", args[i + 1]);
            }
            if (args[i].equals("-l")) {
                res.put("list", args[i + 1]);
            }
            if (args[i].equals("-s")) {
                res.put("stat", args[i + 1]);
            }
            if (args[i].equals("-c")) {
                res.put("mode", "count");
            }
            ++i;
        }
        if (!(res.containsKey("defProp") && res.containsKey("defTri") && res.containsKey("out") && (res.containsKey("in") || res.containsKey("list")))) {
            Main.printUsage();
            System.exit(1);
        }
        if (res.containsKey("in") && res.containsKey("list")) {
            System.err.println("please choose one mode 1 or 2");
            Main.printUsage();
            System.exit(1);
        }
        if (!res.containsKey("mode")) {
            res.put("mode", "binary");
        }
        return res;
    }
}

