/*
 * Decompiled with CFR 0.152.
 */
package io;

import data.Atom;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import utils.NotDefException;

public class PropertiesBuilder {
    private String resDef = "";
    private Hashtable<String, ArrayList<String>> props = new Hashtable();

    public PropertiesBuilder() {
    }

    public PropertiesBuilder(String resDef) {
        this.resDef = resDef;
        try {
            FileReader fr = new FileReader(this.resDef);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            while ((line = br.readLine()) != null) {
                String[] mots = line.trim().split("\\s+");
                String[] properties = null;
                ArrayList<String> tmp = new ArrayList<String>();
                if (mots.length > 2) {
                    properties = mots[2].split(",");
                    int i = 0;
                    while (i < properties.length) {
                        tmp.add(properties[i]);
                        ++i;
                    }
                }
                this.props.put(String.valueOf(mots[0]) + ":" + mots[1], tmp);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<String> assignProp(Atom at) throws NotDefException {
        if (!this.props.containsKey(String.valueOf(at.getResiduName()) + ":" + at.getName()) && (at.getName().toUpperCase().equals("FE") || at.getName().toUpperCase().equals("MN") || at.getName().toUpperCase().equals("ZN") || at.getName().toUpperCase().equals("NI") || at.getName().toUpperCase().equals("CU") || at.getName().toUpperCase().equals("CD") || at.getName().toUpperCase().equals("CO")) && !this.props.containsKey(String.valueOf(at.getName()) + ":" + at.getName())) {
            throw new NotDefException(String.valueOf(at.getResiduName()) + ":" + at.getName() + ";" + at);
        }
        if (at.isOXTres() && at.getType().equals("O.2")) {
            ArrayList<String> res = new ArrayList<String>((Collection)this.props.get(String.valueOf(at.getResiduName()) + ":" + at.getName()));
            res.add("-");
            return res;
        }
        ArrayList<String> res = new ArrayList<String>();
        if (at.getName().toUpperCase().equals("FE") || at.getName().toUpperCase().equals("MN") || at.getName().toUpperCase().equals("ZN") || at.getName().toUpperCase().equals("NI") || at.getName().toUpperCase().equals("CU") || at.getName().toUpperCase().equals("CD") || at.getName().toUpperCase().equals("CO")) {
            res = new ArrayList(this.props.get(String.valueOf(at.getName()) + ":" + at.getName()));
            return res;
        }
        return this.props.get(String.valueOf(at.getResiduName()) + ":" + at.getName());
    }

    public static void main(String[] args) {
        PropertiesBuilder pb = new PropertiesBuilder(args[0]);
        System.out.println(pb.props);
    }
}

