/*
 * Decompiled with CFR 0.152.
 */
package io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;

public class PharmacophoreDefReader {
    private String fileDef = "";
    private ArrayList<String> propUsed = new ArrayList();
    private double[] bins;
    private Hashtable<String, Integer> hashFP;
    private int fpSize = 0;

    public static void main(String[] args) {
        PharmacophoreDefReader pdr = new PharmacophoreDefReader(args[0]);
        System.out.println(pdr.hashFP.size());
    }

    public PharmacophoreDefReader() {
    }

    public PharmacophoreDefReader(String fileDef) {
        this.fileDef = fileDef;
        this.hashFP = new Hashtable();
        try {
            FileReader fr = new FileReader(this.fileDef);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            while ((line = br.readLine()) != null) {
                int i;
                String[] temp;
                String[] mots = line.split(":");
                if (line.matches("bins.*")) {
                    temp = mots[1].trim().split("\\s+");
                    this.bins = new double[temp.length];
                    i = 0;
                    while (i < temp.length) {
                        this.bins[i] = new Double(temp[i]);
                        ++i;
                    }
                    continue;
                }
                if (line.matches("properties.*")) {
                    temp = mots[1].trim().split("\\s+");
                    i = 0;
                    while (i < temp.length) {
                        this.propUsed.add(temp[i]);
                        ++i;
                    }
                    continue;
                }
                this.hashFP.put(String.valueOf(mots[0]) + ":" + mots[1], new Integer(mots[2]));
                this.fpSize = new Integer(mots[2]);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getFpSize() {
        return this.fpSize + 1;
    }

    public double[] getBins() {
        return this.bins;
    }

    public ArrayList<String> getPropUsed() {
        return this.propUsed;
    }

    public int getFpPosition(String tri) {
        if (!this.hashFP.containsKey(tri)) {
            System.out.println(tri);
        }
        return this.hashFP.get(tri);
    }
}

