/*
 * Decompiled with CFR 0.152.
 */
package io;

import data.Atom;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class Mol2Reader {
    private String mol2fileName = "";
    private ArrayList<Atom> listAt = new ArrayList();
    private String resOXT = "";
    private String molName = "";

    public Mol2Reader(String mol2fileName) {
        this.mol2fileName = mol2fileName;
        try {
            Atom at;
            FileReader fr = new FileReader(this.mol2fileName);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            boolean atomFlag = false;
            boolean nameFlag = false;
            String resOxt = "";
            while ((line = br.readLine()) != null) {
                if (line.startsWith("@<TRIPOS>BOND")) {
                    atomFlag = false;
                }
                if (atomFlag) {
                    String[] mots = line.split("\\s+");
                    mots[8] = mots[8].replaceAll("\\d", "");
                    if (mots[2].equals("OXT")) {
                        resOxt = String.valueOf(mots[8]) + mots[7];
                    }
                    if (mots[9].equals("40.0000")) {
                        at = new Atom(new Double(mots[3]), new Double(mots[4]), new Double(mots[5]), new Integer(mots[1]), mots[2], mots[6], mots[8], mots[7]);
                        this.listAt.add(at);
                    }
                }
                if (line.startsWith("@<TRIPOS>ATOM")) {
                    atomFlag = true;
                }
                if (nameFlag) {
                    this.molName = line.trim();
                    nameFlag = false;
                }
                if (!line.startsWith("@<TRIPOS>MOLECULE")) continue;
                nameFlag = true;
            }
            int i = 0;
            while (i < this.listAt.size()) {
                at = this.listAt.get(i);
                if ((String.valueOf(at.getResiduName()) + at.getResID()).equals(resOxt)) {
                    at.setOXTres(true);
                    this.listAt.set(i, at);
                }
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Mol2Reader() {
    }

    public static void main(String[] args) {
        Mol2Reader mr = new Mol2Reader(args[0]);
        System.out.println(mr.getListAt().size());
        for (Atom at : mr.getListAt()) {
            if (!at.isOXTres()) continue;
            System.out.println(at);
        }
    }

    public ArrayList<Atom> getListAt() {
        return this.listAt;
    }

    public void setListAt(ArrayList<Atom> listAt) {
        this.listAt = listAt;
    }

    public String getResOXT() {
        return this.resOXT;
    }

    public String getName() {
        return this.molName;
    }
}

