#ifndef SVMBV_HPP
#define SVMBV_HPP
#include <ctype.h>
#include "svm.h"

#include "oechem.h"
#include "oesystem.h"
using namespace OEChem;
using namespace OEMath;
using namespace OESystem;
using namespace std;

class SVM{
public:
    SVM();
    ~SVM();
    void Reset();
    inline void AddBVTrain(OEBitVector BV){
/************************************************************/
/* Add a bit vector to the training set                     */
/* G. Marcou                                                */
/************************************************************/
	SVM::BVTrain.push_back(BV);
	return;
    };
    inline void SetBVTrain(vector<OEBitVector> BV){
/************************************************************/
/* Set the bit vector training set.                         */
/* G. Marcou                                                */
/************************************************************/
	SVM::BVTrain=BV;
	return;
    };
    inline vector<OEBitVector> GetBVTrain(){
/************************************************************/
/* Get the bit vector training set.                         */
/* G. Marcou                                                */
/************************************************************/
	return(SVM::BVTrain);
    };
    inline void AddClasses(double d){
/************************************************************/
/* Add a class to the training set                          */
/* G. Marcou                                                */
/************************************************************/
	SVM::classes.push_back(d);
	return;
    };
    inline void SetClasses(vector<double> d){
/************************************************************/
/* Set the classes training set.                            */
/* G. Marcou                                                */
/************************************************************/
	SVM::classes.clear();
	SVM::classes=d;
	return;
    };
    inline vector<double> GetClasses(){
/************************************************************/
/* Get the classes training set.                            */
/* G. Marcou                                                */
/************************************************************/
	return(SVM::classes);
    };
    inline void SetSVMProblem(svm_problem prb){
/************************************************************/
/* Set the SVM problem                                      */
/* G. Marcou                                                */
/************************************************************/
	SVM::problem=prb;
	return;
    };
    inline svm_problem GetSVMProblem(){
/************************************************************/
/* Get the SVM problem                                      */
/* G. Marcou                                                */
/************************************************************/
	return(SVM::problem);
    };
    inline void SetSVMParameter(svm_parameter prm){
/************************************************************/
/* Set the SVM parameter                                    */
/* G. Marcou                                                */
/************************************************************/
	SVM::param=prm;
	return;
    };
    inline svm_parameter GetSVMParameter(){
/************************************************************/
/* Get the SVM parameter                                    */
/* G. Marcou                                                */
/************************************************************/
	return(SVM::param);
    };
    void Training(vector<OEBitVector>&, vector<double>&);
    void SetModel();
    inline svm_model* GetModel(){
/************************************************************/
/* Get the SVM model                                        */
/* G. Marcou                                                */
/************************************************************/
	return(SVM::model);
    };
    double Predict(OEBitVector);
private:
    int TrngSze;
    svm_model* model;
    vector<double> classes;
    vector<OEBitVector> BVTrain;
    vector<vector<svm_node> > nodes;
    svm_node* node_space;
    svm_problem problem;
    svm_parameter param;
};
#endif
