#include "MyAFP.hpp"
double MyAFP::SmartDist=5.0;
OEQMol MyAFP::SmartA;
OEQMol MyAFP::SmartB;
OESubSearch MyAFP::SSA;
OESubSearch MyAFP::SSB;


MyAFP::MyAFP(){
//
    AFP::SetTopPrime(20);
    AFP::SetPrimNbre();
//
    MyAFP::IsSmartA=false;
    MyAFP::IsSmartB=false;
//
    for(int i=0;i<3;++i)
	SmartCG[i]=0;
//
}

void MyAFP::SetIsSmartA(OEMolBase &mol, OEAtomBase* X){
    OEIter<OEMatchBase> match;
    for (match = MyAFP::SSA.Match(mol,true);match;++match){
	OEIter<OEMatchPair<OEAtomBase> > apr;
	MyAFP::IsSmartA=false;
	for (apr = match->GetAtoms();apr;++apr){
	    if(apr->target==X){
		MyAFP::IsSmartA=true;
		return;
	    };
	};
    };
    return;
};
void MyAFP::SetIsSmartB(OEMolBase &mol, OEAtomBase* X){
    OEIter<OEMatchBase> match;
    for (match = MyAFP::SSB.Match(mol,true);match;++match){
	OEIter<OEMatchPair<OEAtomBase> > apr;
	MyAFP::IsSmartB=false;
	for (apr = match->GetAtoms();apr;++apr){
	    if(apr->target==X){
		MyAFP::IsSmartB=true;
		return;
	    };
	};
    };
    return;
};

void MyAFP::SetProperties(OEMolBase& mol, OEAtomBase *X){//Set all properties
    AFP::SetProperties(X);
    //
    MyAFP::SetIsSmartA(mol,X);
    MyAFP::SetIsSmartB(mol,X);
    return;
};
/************************************************************/
//Tools
void MyAFP::PropReset(){
/************************************************************/
/* Reset properties                                         */
/* G. Marcou                                                */
/************************************************************/
    //
    AFP::PropReset();
    MyAFP::IsSmartA=false;
    MyAFP::IsSmartB=false;
    for(int i=0;i<3;++i)
	SmartCG[i]=0;
    return;
};
// void MyAFP::FindSmartCG(OEMolBase &mol,OEAtomBase *X){
//     if((!IsSmartA)&&(!IsSmartB)) return;
//     bool found;
//     found=false;
//     OEIter<OEMatchBase> match;
//     OESubSearch ss;
//     if(IsSmartA) ss=MyAFP::SSA;
//     if(IsSmartB) ss=MyAFP::SSB;
//     double CG[3],U[3];
//     for (match = ss.Match(mol,true);match;++match){
// 	OEIter<OEMatchPair<OEAtomBase> > apr;
// 	int Natm=0;
// 	for(int i=0;i<3;++i){
// 	    CG[i]=0;
// 	    U[i]=0;
// 	};
// 	for (apr = match->GetAtoms();apr;++apr){
// 	    Natm++;
// 	    if(X==apr->target) found=true;
// 	    mol.GetCoords(apr->target,U);
// 	    OEGeom3DAdd(CG,U);
// 	};
// 	if(found){
// 	    for(int i=0; i<3; ++i) MyAFP::SmartCG[i]=CG[i]/Natm;
// 	    return;
// 	};
//     };
//     if(!found)
// 	for(int i=0; i<3; ++i) MyAFP::SmartCG[i]=0;
//     return;
// };
/************************************************************/
void MyAFP::SetDirections(OEMolBase &mol, OEAtomBase *X){
/************************************************************/
/* Set directions of aromaticity and H-bonds                */
/* G. Marcou                                                */
/************************************************************/
    AFP::SetDirections(mol,X);
//
    FindSmartCG(mol,X);
//
    return;
};
int operator + (const MyAFP &a, const MyAFP &b){
/************************************************************/
/* Addition operator: given two Atomic Finger Prints, check */
/* what kind of interactions actually exists.               */
/*       1: No interactions                                 */
/*       2: Hydrophobic                                     */
/*       3: Pi stacking                                     */
/*       5: Edge to face                                    */
/*       7: H-bond Donor Acceptor                           */
/*      11: H-bond Acceptor Donor                           */
/*      13: Ionic interaction + -                           */
/*      17: Ionic interaction - +                           */
/*      19: Smarts interactions                             */
/* Multiple kind of interactions are given by products:     */
/*    Hydrophobic AND Pi stacking= 3*5                      */
/* G. Marcou                                                */
/************************************************************/
    int Inter;
    Inter=1;
    AFP aAFP,bAFP;
    map<int,int> PrimNbre=AFP::GetPrimNbre();
    map<int,int>::iterator _PrimNbre=PrimNbre.begin();
//
    aAFP=a; bAFP=b;
    Inter=aAFP+bAFP;
    for(unsigned int j=0;j<AFP::GetBitNbre();j++)
	_PrimNbre++;
//
    if(MyAFP::GetSmartDist()>0){
	if((a.IsSmartA&&b.IsSmartB)||(a.IsSmartB&&b.IsSmartA)){
	    if(OEGeom3DDistance(a.SmartCG,b.SmartCG)<MyAFP::SmartDist)Inter*=19;
	};
    };
//
    return(Inter);
};
