#include "MFP.hpp"
unsigned int MFP::ResBVSize=0;
//
MFP::MFP(){
    MFP::SetResBVSize(AFP::GetBitNbre());    
    cout << "Top Prime: " << AFP::GetTopPrime() << endl;
    cout << " Residue Bit Vector Size: " << MFP::GetResBVSize() << endl;
    MFP::IMolFPClear();
};
/****************************************************/
MFP::MFP(OEMol &mol){
    MFP::cav=mol;
    MFP::SetResBVSize(AFP::GetBitNbre());    
    cout << "Top Prime: " << AFP::GetTopPrime() << endl;
    cout << " Residue Bit Vector Size: " << MFP::GetResBVSize() << endl;
    MFP::IMolFPClear();
};
/****************************************************/
void MFP::InitResBVPos(){
/****************************************************/
/* Initialize the residue index to position in the  */
/* BitVector vector.                                */
/* G. Marcou                                        */
/****************************************************/
    OEIter<OEAtomBase> cavat;
    OEResidue cavres;
    string SResID;
    map<string,int>::iterator _ResBVPos;
    int ResCpt;
//
    ResCpt=0;//Residue counting, index in MFP vector
    for(cavat=MFP::cav.GetAtoms();cavat;++cavat){
        cavres=OEAtomGetResidue(cavat);
        ostringstream Snum;
	Snum << cavres.GetResidueNumber();
	SResID=cavres.GetChainID()+Snum.str()+cavres.GetName();
//SResID identifies residues by ChainID, number, and Name
	_ResBVPos=MFP::ResBVPos.find(SResID);
	if(_ResBVPos==MFP::ResBVPos.end()){//This a new residue
	    MFP::ResBVPos[SResID]=ResCpt;//init. the ResBVPos map.
	    ++ResCpt;
	};
    };
//
    return;
};
/****************************************************/
void MFP::SetIMolFP(OEMol &lig){
/****************************************************/
/* Set the Molecular Interaction Finger Print based */
/* on a cavity OEMol and ligand OEMol.              */
/* G. Marcou                                        */
/****************************************************/
    OEIter<OEAtomBase> ligat,cavat;
    OEResidue cavres;
//
    AFP cavFP,ligFP;//atomic finger prints
    map<string,int> ResBVPos;
    map<int,int> NbrePrem;//Map Res. to pos. in MFP, Nbre. Premiers 
    map<string,int>::iterator _ResBVPos;
    map<int,int>::iterator _NbrePrem;
//vector of RFP, vector of MFP: multi-molecule finger print
    vector<OEBitVector> VRFP;
    vector<OEBitVector>::iterator _VRFP;
    string SResID;//strings for OEBitVector to Hex conversion
    int inter; //interaction identifier
//
// Prime number inter. code to residue finger print inter. code map init.
    NbrePrem=AFP::GetPrimNbre();
    MFP::SetResBVSize(AFP::GetBitNbre());
    OEBitVector RFP(MFP::GetResBVSize());//Residue finger print
//
//Initialize ResBVPos if needed and VRFP
    if(MFP::ResBVPos.size()==0)
	InitResBVPos();
    for(_ResBVPos=MFP::ResBVPos.begin();_ResBVPos!=MFP::ResBVPos.end();++_ResBVPos){
	RFP.ClearBits();
	VRFP.push_back(RFP);
    };
//
    for(cavat=MFP::cav.GetAtoms();cavat;++cavat){
// Choose the residue finger print related to cavat
        cavres = OEAtomGetResidue(cavat);
        ostringstream Snum;
	Snum << cavres.GetResidueNumber();
	SResID=cavres.GetChainID()+Snum.str()+cavres.GetName();
//SResID identifies residues by ChainID, number, and Name
	_ResBVPos=MFP::ResBVPos.find(SResID);
	RFP=VRFP[_ResBVPos->second];
//
	cavFP.PropReset();
	cavFP.SetProperties(cavat);
	cavFP.SetDirections(MFP::cav,cavat);//Set cavity atom finger print
	for(ligat=lig.GetAtoms();ligat;++ligat){
	    ligFP.PropReset();
	    ligFP.SetProperties(ligat);
	    ligFP.SetDirections(lig,ligat);//Set ligand atom finger print
//
	    inter=cavFP+ligFP;//Get the characteristic int. of the inter.
// //DEBUG
// 	    bool print=false;
//	    if(inter!=1){
// 		print=true;
// 		cout << cavres.GetName() << " "
// 		     << SResID << " "
// 		     << ligat->GetName() << " "
// 		     << inter << " ";
// 	    };
// //DEBUG
	    while(inter!=1)//There's an inter. between cavat & ligat
//Transpose the characteristic int. in RFP bit position
		for(_NbrePrem=NbrePrem.begin();
		    _NbrePrem!=NbrePrem.end();++_NbrePrem)
		    if(inter%_NbrePrem->second==0){
			RFP.SetBitOn(unsigned(_NbrePrem->first));
			inter=inter/_NbrePrem->second;
		    };
	};
	//Average the interactions over the residue
//replace the old finger print
	VRFP[_ResBVPos->second]=RFP;
    };
//From VRFP vector to MFP
    unsigned int sze=0;
    for(_VRFP=VRFP.begin();_VRFP!=VRFP.end();++_VRFP){
	for(unsigned int i=0; i<_VRFP->GetSize(); ++i, ++sze){
	    if(_VRFP->IsBitOn(i))
		MFP::IMolFP.SetBitOn(sze);
	};
	if(MFP::IMolFP.GetSize()<sze)
	    MFP::IMolFP.SetBitOff(sze-1);
    };
//
    return;
};
