#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <vector>
#include <map>
#include <sstream>
#include "oechem.h"
#include "oesystem.h"
#include "AFP.hpp"
#include "MFP.hpp"
#include "SmlstRng.hpp"
#include "LBMFPInOut.hpp"
using namespace OEChem;
using namespace OEMath;
using namespace OESystem;
using namespace std;

int main(int argc, char *argv[]){
//
    OEMol lig,cav;
    OEIter<OEAtomBase> ligat,cavat;
    oemolistream ims;
//
    vector<OEBitVector> RefFP,MMFP;
    vector<OEBitVector>::iterator _MMFP;
//
    vector<double> Tanimo;
    vector<double>::iterator _Tanimo;
    vector< vector<double> > MTanimo;
    vector< vector<double> >::iterator _MTanimo;
    vector<string> ListRef,ListEle;
    vector<string>::iterator _Ele;
//
// User interface
    string CavFile,FileListNme,RefListNme,LigFile,OutName;
    bool BitVector;
//
    string RefNme, s_BV;
    istringstream is_BV;
//
    welcome();
//
    int err;
    err=0;
    err=UserInterface(argc,argv,CavFile,RefListNme,FileListNme,OutName,BitVector);
    if(err) return 1;
//
// Setting the cavity
    ims.SetFormat(OEFormat::MOL2);
    if(!ims.open(CavFile.c_str())){
	cout << "************main Error***********"<< endl;
	cout << "File " << CavFile << " does not exists!" << endl;
	cout << "*********************************"<< endl;
	return 1;
    };
    ims >> cav;
    ims.close();
//    
    if (OEHasResidues(cav))
    {
	OEPDBOrderAtoms(cav);
    }
    else OEPerceiveResidues(cav);
//
    MFP CavLig(cav);
//
    ifstream FileList;
    FileList.open(RefListNme.c_str());
    if(!FileList){
	cout << "************main Error***********"<< endl;
	cout << "File " << RefListNme << " does not exists!" << endl;
	cout << "*********************************"<< endl;
	return 1;
    };
//
//Reference processing
    if(!BitVector){//ligand 
	FileList >> LigFile;
	while(FileList){//process sequencially the ligand files stored
	    cout << "Processing Reference " << LigFile << endl;
	    ims.SetFormat(OEFormat::MOL2);
	    if(!ims.open(LigFile.c_str())){
		cout << "********main loop Warning********"<< endl;
		cout << "Ligand file " << LigFile << " does not exists!" << endl;
		cout << "*********************************"<< endl;
		FileList >> LigFile;
		continue ;
	    };
	    while(ims >> lig){
		LigFile=lig.GetTitle();
		cout << "Title: " << LigFile << endl;
		ListRef.push_back(LigFile);
//
		CavLig.ResetIMolFP();
//		CavLig.SetCav(cav);
		CavLig.SetIMolFP(lig);
		RefFP.push_back(CavLig.GetIMolFP());
	    };
//
	    ims.close();
	    FileList >> LigFile;
	};//All Ref files have been processed
    } else {//Bit Vector
	FileList >> RefNme >> s_BV;
	while(FileList){//process sequencially the ligand files stored
	    CavLig.ResetIMolFP();
	    is_BV.clear();
	    is_BV.str(s_BV);
	    ListRef.push_back(RefNme);
	    is_BV >> CavLig;
	    RefFP.push_back(CavLig.GetIMolFP());
	    FileList >> RefNme >> s_BV;
	};
    };
    FileList.close();
//
//docked ligands
    ifstream FileListLig;
    FileListLig.open(FileListNme.c_str());
    if(!FileListLig){
	cout << "************main Error***********"<< endl;
	cout << "File " << FileListNme << " does not exists!" << endl;
	cout << "*********************************"<< endl;
	return 1;
    };
//
    FileListLig >> LigFile;
    while(FileListLig){//process sequencially the ligand files stored
	cout << "Processing " << LigFile << endl;
	ims.SetFormat(OEFormat::MOL2);
	if(!ims.open(LigFile.c_str())){
	    cout << "********main loop Warning********"<< endl;
	    cout << "Ligand file " << LigFile << " does not exists!" << endl;
	    cout << "*********************************"<< endl;
	    FileListLig >> LigFile;
	    continue ;
	};
	while(ims >> lig){
	    LigFile=lig.GetTitle();
	    cout << "Title: " << LigFile << endl;
	    ListEle.push_back(LigFile);
//
	    CavLig.ResetIMolFP();
//	    CavLig.SetCav(cav);
	    CavLig.SetIMolFP(lig);
	    MMFP.push_back(CavLig.GetIMolFP());
//
	    cout << CavLig << endl;
//
//Evaluate Tanimoto of this lig. file to all other previously processed
	    double d;
	    for(_MMFP=RefFP.begin();_MMFP!=RefFP.end();++_MMFP){
		d=OETanimoto(CavLig.GetIMolFP(),*_MMFP);
		Tanimo.push_back(d);
	    };
	    MTanimo.push_back(Tanimo);
	    Tanimo.clear();
	};
	ims.close();
	FileListLig >> LigFile;
    };//All files have been processed
    FileListLig.close();
//
// Output
    cout << endl;
    cout << "Similarity binding Tanimoto" << endl;
    for(_Ele=ListRef.begin();_Ele<ListRef.end();++_Ele)
      cout << *_Ele << "\t";
    cout << endl;
//
    cout << setprecision(3) << fixed << setw(4);
    int i;
    i=0;
    for(_MTanimo=MTanimo.begin();_MTanimo<MTanimo.end();++_MTanimo){
	Tanimo=*_MTanimo;
	cout << ListEle[i] << " ";
 	for(_Tanimo=Tanimo.begin();_Tanimo!=Tanimo.end();++_Tanimo)
	    cout << *_Tanimo << " ";
	cout << endl;
	++i;
    };
    cout << endl;
//
    i=0;
    ofstream OutFile;
    OutFile.open(OutName.c_str());
//
    for(_Ele=ListRef.begin();_Ele<ListRef.end();++_Ele)
      OutFile << *_Ele << "\t";
    OutFile << endl;
//
    cout << setprecision(3) << fixed << setw(4);
    for(_MTanimo=MTanimo.begin();_MTanimo<MTanimo.end();++_MTanimo){
	Tanimo=*_MTanimo;
	OutFile << ListEle[i] << " ";
 	for(_Tanimo=Tanimo.begin();_Tanimo!=Tanimo.end();++_Tanimo)
	    OutFile << *_Tanimo << " ";
	OutFile << endl;
	++i;
    };
    cout << endl;
//
    return(1);
};

