#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <vector>
#include <map>
#include "oechem.h"
#include "oesystem.h"
#include "AFP.hpp"
#include "MAFP.hpp"
#include "SmlstRng.hpp"
#include "IAFPInOut.hpp"
#include "treemedoid.hpp"
#include "Cluster2TreeView.hpp"
extern "C"{
#include "cluster.h"
}
using namespace OEChem;
using namespace OEMath;
using namespace OESystem;
using namespace std;

int main(int argc, char *argv[]){
//
    OEMol lig,cav;
    OEIter<OEAtomBase> ligat,cavat;
    oemolistream ims;
//
    vector<OEBitVector> MMFP;
    vector<OEBitVector>::iterator _MMFP;
    string BVstring,allBV;
//
    int nele,nrows,ncolmn;
    double** p_CTanimo;
    vector<double> Tanimo;
    vector<double>::iterator _Tanimo;
    vector< vector<double> > MTanimo;
    vector< vector<double> >::iterator _MTanimo;
    vector<string> ListEle;
//
// User interface
    string CavFile,FileListNme,LigFile,OutName;
    char ClustMeth;//Clustering method
//
    welcome();
//
    int err;
    err=0;
    err=UserInterface(argc,argv,FileListNme,OutName,ClustMeth);
    if(err) return 1;
//
    ifstream FileList(FileListNme.c_str());
    if(!FileList){
	cout << "************main Error***********"<< endl;
	cout << "File " << FileListNme << " does not exists!" << endl;
	cout << "*********************************"<< endl;
	return 1;
    };
//
    FileList >> LigFile >> CavFile;
    nele=0;nrows=0;ncolmn=0;
    while(FileList){//process sequencially the cavity files stored
// Setting the ligand
	cout << "Processing " << LigFile << "\t" << CavFile << endl;
//
	ims.SetFormat(OEFormat::MOL2);
	if(!ims.open(LigFile.c_str())){
	    cout << "************main Error***********"<< endl;
	    cout << "File " << LigFile << " does not exists!" << endl;
	    cout << "*********************************"<< endl;
	    continue;
	};
	ims >> lig;
	ims.close();
//
	MAFP CavLig(lig);
//
	ims.SetFormat(OEFormat::MOL2);
	if(!ims.open(CavFile.c_str())){
	    cout << "********main loop Warning********"<< endl;
	    cout << "Cavity file " << CavFile << " does not exists!" << endl;
	    cout << "*********************************"<< endl;
	    FileList >> CavFile;
	    continue ;
	};
	ims >> cav;
	ims.close();
//
	if (OEHasResidues(cav))
	{
	    OEPDBOrderAtoms(cav);
	}
	else OEPerceiveResidues(cav);
//
	ListEle.push_back(CavFile);
//
	CavLig.ResetIMolFP();
	CavLig.SetLig(lig);
	CavLig.SetIMolFP(cav);
	MMFP.push_back(CavLig.GetIMolFP());
	allBV.clear();
//
	cout << CavLig << endl;
//Evaluate Tanimoto of this lig. file to all other previously processed
	double d;
	ncolmn=0;
	for(_MMFP=MMFP.begin();_MMFP!=MMFP.end();++_MMFP){
	    d=1.0-OETanimoto(CavLig.GetIMolFP(),*_MMFP);
	    Tanimo.push_back(d);
	    ++nele;++ncolmn;
	};
	++nrows;
	MTanimo.push_back(Tanimo);
	Tanimo.clear();
	FileList >> LigFile >> CavFile;
    };//All files have been processed
//
    cout << endl;
    cout << "Distance Matrix" << endl;
    cout << setprecision(3) << fixed << setw(4);
    for(_MTanimo=MTanimo.begin();_MTanimo<MTanimo.end();++_MTanimo){
	Tanimo=*_MTanimo;
 	for(_Tanimo=Tanimo.begin();_Tanimo!=Tanimo.end()-1;++_Tanimo)
	    cout << *_Tanimo << " ";
	cout << endl;
    };
    cout << endl;
//Cluster
    int i;
    p_CTanimo=new double*[nrows];
    p_CTanimo[0]=0;//NULL
    for(i=1;i<nrows;++i)
 	p_CTanimo[i]=new double [i];
    i=0;
    for(_MTanimo=MTanimo.begin();_MTanimo<MTanimo.end();++_MTanimo){
	Tanimo=*_MTanimo;
	int j; j=0;
 	for(_Tanimo=Tanimo.begin();_Tanimo!=Tanimo.end()-1;++_Tanimo){
	    p_CTanimo[i][j]=*_Tanimo;
	    ++j;
	};++i;
    };
//
    int npass;
    double dist;
    int *clusterid;
    clusterid=new int [nrows];
    int* OldId;
    OldId=new int [nrows];
    npass=1000;
    dist=0;
    for(i=0;i<nrows;++i)
	OldId[i]=i;
    ofstream OutTreeFile;
//    int result[nrows-1][2];
//    double linkdist[nrows-1];
    Node treenodes[nrows-1];
    Node *_treenodes = new Node [nrows-1];
    if(ClustMeth=='k'){
	treekmedoid(nrows,npass,p_CTanimo,OldId,dist,treenodes);
	NexusTreeOut(nrows,treenodes,OutName,ListEle);
    }else{
	_treenodes=treecluster(nrows,ncolmn,0,0,0,0,'e',ClustMeth,p_CTanimo);
	NexusTreeOut(nrows,_treenodes,OutName,ListEle);
    };
//
    return(1);
};

