#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <vector>
#include <map>
#include "oechem.h"
#include "oesystem.h"
#include "AFP.hpp"
#include "MFP.hpp"
#include "Bayes.hpp"
#include "SmlstRng.hpp"
#include "BayesInOut.hpp"
#include "treemedoid.hpp"
#include "Cluster2TreeView.hpp"
extern "C"{
#include "cluster.h"
}
using namespace OEChem;
using namespace OEMath;
using namespace OESystem;
using namespace std;

int main(int argc, char *argv[]){
//
    OEMol lig,cav;
    OEIter<OEAtomBase> ligat,cavat;
    oemolistream ims;
//
    string BVstring,allBV;
    istringstream is_BV;
//
    vector<string> ListRef,ListEle;
//
    double rActive;
    vector<bool> Active;
    Bayes bayes;
// User interface
    string CavFile,RefListNme,FileListNme,LigFile,OutName;
    string RefNme,s_BV;
    int Machine;
    double MinOn, MinOff;
    bool BitVector;
//
    welcome();
//
    int err;
    err=0;
    err=UserInterface(argc,argv,CavFile,RefListNme,FileListNme,OutName,
		      Machine,MinOn,MinOff,BitVector);
    if(err) return 1;
//
    bayes.SetAlgo(Machine);
    bayes.SetOnSupportMin(MinOn);
    bayes.SetOffSupportMin(MinOn);
// Setting the cavity
    ims.SetFormat(OEFormat::MOL2);
    if(!ims.open(CavFile.c_str())){
	cout << "************main Error***********"<< endl;
	cout << "File " << CavFile << " does not exists!" << endl;
	cout << "*********************************"<< endl;
	return 1;
    };
    ims >> cav;
    ims.close();
//    
    if (OEHasResidues(cav))
    {
	OEPDBOrderAtoms(cav);
    }
    else OEPerceiveResidues(cav);
//
    MFP CavLig(cav);
//
// Train the Bayesian machine
    ifstream RefList(RefListNme.c_str());
    if(!RefList){
	cout << "************main Error***********"<< endl;
	cout << "File " << RefListNme << " does not exists!" << endl;
	cout << "*********************************"<< endl;
	return 1;
    };
//
    if(!BitVector){
	RefList >> LigFile  >> rActive;
	while(RefList){//process sequencially the ligand files stored
	    if(rActive>=1.0)
		Active.push_back(true);
	    else 
		Active.push_back(false);
	    cout << "Processing " << LigFile
		 << " Activity: " << Active.back() <<endl;
	    ims.SetFormat(OEFormat::MOL2);
	    if(!ims.open(LigFile.c_str())){
		cout << "********main loop Warning********"<< endl;
		cout << "Ligand file " << LigFile << " does not exists!" << endl;
		cout << "*********************************"<< endl;
		RefList >> LigFile >> rActive;
		continue ;
	    };
	    while(ims >> lig){
//
		LigFile=lig.GetTitle();
		cout << "Title: " << LigFile << endl;
		ListEle.push_back(LigFile);
//
		CavLig.ResetIMolFP();
//	CavLig.SetCav(cav);
		CavLig.SetIMolFP(lig);
//
		cout << CavLig << endl;
		bayes.Training(CavLig.GetIMolFP(),Active.back());
	    };
	    ims.close();
	    RefList >> LigFile >> rActive;
	};//All files have been processed
    } else {
	RefList >> RefNme >> s_BV >> rActive;
	while(RefList){//process sequencially the ligand files stored
	    if(rActive>=1.0)
		Active.push_back(true);
	    else 
		Active.push_back(false);
	    CavLig.ResetIMolFP();
	    is_BV.clear();
	    is_BV.str(s_BV);
	    ListRef.push_back(RefNme);
	    is_BV >> CavLig;
	    bayes.Training(CavLig.GetIMolFP(),Active.back());
	    RefList >> RefNme >> s_BV >> rActive;
	};
    };
    RefList.close();
//
    switch(bayes.GetAlgo()){
	case 0:
	    bayes.SetInfereBayes();
	    break;
	case 1:
	    bayes.SetInfereXiao();
	    break;
	default:
	    cout <<  "ERROR: Unsuported machine" << endl;
	    exit(1);
	    break;
    };
//
// Infere unknown ligand poses affinity
    ifstream FileList(FileListNme.c_str());
    ofstream FileOut(OutName.c_str());
    if(!FileList){
	cout << "************main Error***********"<< endl;
	cout << "File " << FileListNme << " does not exists!" << endl;
	cout << "*********************************"<< endl;
	return 1;
    };
//
    FileList >> LigFile;
    double Scr;
//     vector<double> vtmp;
//     vector<double>::iterator _vtmp;
//     vtmp=bayes.GetOnInfere();
//     for(_vtmp=vtmp.begin();_vtmp!=vtmp.end();_vtmp++)
//       cout << setw(6) << setprecision(4) << *_vtmp << "|";
//     cout << endl;
//     vtmp=bayes.GetOffInfere();
//     for(_vtmp=vtmp.begin();_vtmp!=vtmp.end();_vtmp++)
//       cout << setw(6) << setprecision(4) << *_vtmp << "|";
//     cout << endl;
    bayes.SetSupport();
//     vtmp=bayes.GetOnSupport();
//     for(_vtmp=vtmp.begin();_vtmp!=vtmp.end();_vtmp++)
//       cout << setw(6) << setprecision(4) << *_vtmp << "|";
//     cout << endl;
//     vtmp=bayes.GetOffSupport();
//     for(_vtmp=vtmp.begin();_vtmp!=vtmp.end();_vtmp++)
//       cout << setw(6) << setprecision(4) << *_vtmp << "|";
//     cout << endl;
    while(FileList){//process sequencially the ligand files stored
	ims.SetFormat(OEFormat::MOL2);
	if(!ims.open(LigFile.c_str())){
	    cout << "********main loop Warning********"<< endl;
	    cout << "Ligand file " << LigFile << " does not exists!" << endl;
	    cout << "*********************************"<< endl;
	    FileList >> LigFile;
	    continue ;
	};
	while(ims >> lig){
//
	    LigFile=lig.GetTitle();
	    cout << "Title: " << LigFile << endl;
	    ListEle.push_back(LigFile);
//
	    CavLig.ResetIMolFP();
	    CavLig.SetIMolFP(lig);
//
	    cout << CavLig;
	    Scr=bayes.Predict(CavLig.GetIMolFP());
	    cout << "Bayesian Score: "
		 << setprecision(2) << setw(8) << Scr << endl;
	    cout << endl;
	    FileOut << LigFile << " " << Scr << endl;
	};
	ims.close();
	FileList >> LigFile;
    };//All files have been processed
//
    FileList.close();
//
    return(0);
};

