#ifndef AFP_HPP
#define AFP_HPP
#include <cmath>
#include <vector>
#include "SmlstRng.hpp"
#include "PropConstants.hpp"
#include "misc.hpp"
#include "oechem.h"
#include "oesystem.h"
#include <string.h>
using namespace OEChem;
using namespace OEMath;
using namespace OESystem;
using namespace std;

class AFP{
/****************************************************/
/* Atomic Finger Print.                             */
/* G. Marcou                                        */
/****************************************************/
public:
//Constructor
    AFP();
//Methods
//Setting
    static inline void SetLcloRng(bool b){//Local or ring aromatic def.
	AFP::LcloRng=b;
	return;
    };
    static inline void SetHdist(double d){//H-bond distance
	AFP::Hdist=d;
	return;
    };
    static inline void SetHangl(double a){//H-bond angle
	AFP::Hangl=a;
	return;
    };
    static inline void SetHdngl(double a){//H-bond angle tolerance
	AFP::Hdngl=a;
	return;
    };
    static inline void SetPSdist(double d){//Pi stacking distance
	AFP::PSdist=d;
	return;
    };
    static inline void SetPSangl(double a){//Pi stacking angle
	AFP::PSangl=a;
	return;
    };
    static inline void SetPSdngl(double a){//Pi stacking angle tolerance
	AFP::PSdngl=a;
	return;
    };
    static inline void SetEFdist(double d){//Edge to face distance
	AFP::EFdist=d;
	return;
    };
    static inline void SetEFangl(double a){//Edge to face angle
	AFP::EFangl=a;
	return;
    };
    static inline void SetEFdngl(double a){//Edge to face angle tolerance
	AFP::EFdngl=a;
	return;
    };
    static inline void SetHydist(double d){//Hydrophibic contact distance
	AFP::Hydist=d;
	return;
    };
    static inline void SetIondst(double d){//ionic distance
	AFP::Iondst=d;
	return;
    };
//Getting
    static inline bool GetLcloRng(){//Local or ring aromatic def.
	return(AFP::LcloRng);
    };
    static inline double GetHdist(){//H-bond distance
	return(AFP::Hdist);
    };
    static inline double GetHangl(){//H-bond angle
	return(AFP::Hangl);
    };
    static inline double GetHdngl(){//H-bond angle tolerance
	return(AFP::Hdngl);
    };
    static inline double GetPSdist(){//Pi stacking distance
	return(AFP::PSdist);
    };
    static inline double GetPSangl(){//Pi stacking angle
	return(AFP::PSangl);
    };
    static inline double GetPSdngl(){//Pi stacking angle tolerance
	return(AFP::PSdngl);
    };
    static inline double GetEFdist(){//Edge to face distance
	return(AFP::EFdist);
    };
    static inline double GetEFangl(){//Edge to face angle
	return(AFP::EFangl);
    };
    static inline double GetEFdngl(){//Edge to face angle tolerance
	return(AFP::EFdngl);
    };
    static inline double GetHydist(){//Hydrophibic contact distance
	return(AFP::Hydist);
    };
    static inline double GetIondst(){//ionic distance
	return(AFP::Iondst);
    };
//Kind of potential interaction
//Setting
    inline void SetIsHD(bool b){//Is an H-bond donnor
	IsHD=b;
	return;
    };
    void SetIsHD(OEAtomBase *X);//Is an H-bond donnor
    inline void SetIsHA(bool b){//Is an H-bond acceptor
	IsHA=b;
	return;
    };
    void SetIsHA(OEAtomBase *X);//Is an H-bond acceptor
    inline void SetIsAr(bool b){//Is an Aromatic
	IsAr=b;
	return;
    };
    inline void SetIsAr(OEAtomBase *X){//Is an Aromatic
	IsAr=false;
	IsAr=X->IsAromatic();
	return;
    };
    inline void SetIsHy(bool b){//Is Hydrophobe
	IsHy=b;
	return;
    };
    void SetIsHy(OEAtomBase *X);//Is Hydrophobe
    inline void SetIsCat(bool b){//Is a formal cation
	IsCat=b;
	return;
    };
    inline void SetIsCat(OEAtomBase *X){//Is a formal cation
	IsCat=false;
	IsCat=(X->GetFormalCharge()>0);
        if (X->IsMetal()) IsCat=false;
	return;
    };
    inline void SetIsAnn(bool b){//Is a formal anion
	IsAnn=b;
	return;
    };
    inline void SetIsAnn(OEAtomBase *X){//Is a formal anion
	IsAnn=false;
	IsAnn=(X->GetFormalCharge()<0);
           if (strcmp(X->GetType(),"O.co2")==0)
     IsAnn=true;
	return;
    };
    void SetProperties(OEAtomBase *X);//Set all properties
//Tools
    void PropReset();//Reset properties
    void SetDirections(OEMolBase &mol, OEAtomBase *X);
    static inline void SetTopPrime(unsigned int i){
	AFP::TopPrime=i;
	return;
    };
    static inline unsigned int GetTopPrime(){
	return(AFP::TopPrime);
    };
    static inline void SetPrimNbre(){
	AFP::PrimNbre.clear();
	AFP::PrimNbre=Eratosthene(AFP::GetTopPrime());
	return;
    };
    static inline map<int,int> GetPrimNbre(){
	return(AFP::PrimNbre);
    };
    static inline unsigned int GetPrimNbreSze(){
	return(AFP::PrimNbre.size());
    };
    static inline unsigned int GetBitNbre(){
	unsigned int cpt;
	cpt=0;
	if(AFP::GetHdist()>0)
	    cpt+=2;
	if(AFP::GetPSdist()>0)
	    cpt++;
	if(AFP::GetEFdist()>0)
	    cpt++;
	if(AFP::GetHydist()>0)
	    cpt++;
	if(AFP::GetIondst()>0)
	    cpt+=2;
	return(cpt);
    };
    inline void SetHAGC(double X[3]){//Set Hbond Acceptor Geometric Center
	for(int i=0;i<3;++i) AFP::HAGC[i]=X[i];
	return;
    };
    inline void SetHDGC(double X[3]){//Set Hbond Donor Geometric Center
	for(int i=0;i<3;++i) AFP::HAGC[i]=X[i];
	return;
    };
    inline void SetAroGC(double X[3]){//Set Aromatic Geometric Center
	for(int i=0;i<3;++i) AFP::AroGC[i]=X[i];
	return;
    };
    inline void SetIoGC(double X[3]){//Set Ion Geometric Center
	for(int i=0;i<3;++i) AFP::HAGC[i]=X[i];
	return;
    };
    inline void SetHDdir(double X[3]){//Set H-bond donnor direction
	for(int i=0;i<3;++i) AFP::HD[i]=X[i];
	return;
    };
    inline void SetNArodir(double X[3]){//Set Aromatic direction
	for(int i=0;i<3;++i) AFP::NAro[i]=X[i];
	return;
    };
//Kind of potential interaction
//Getting
    inline bool GetIsHD() const{//Is an H-bond donnor
	return(IsHD);
    };
    inline bool GetIsHA() const{//Is an H-bond acceptor
	return(IsHA);
    };
    inline bool GetIsAr() const{//Is an Aromatic
	return(IsAr);
    };
    inline bool GetIsHy() const{//Is Hydrophobe
	return(IsHy);
    };
    inline bool GetIsCat() const{//Is a formal cation
	return(IsCat);
    };
    inline bool GetIsAnn() const{//Is a formal anion
	return(IsAnn);
    };
    inline void GetHDdir(double X[3]) const{//Get H-bond donnor direction
	for(int i=0;i<3;++i) X[i]=HD[i];
	return;
    };
    inline void GetNArodir(double X[3]) const{//Get Aromatic direction
	for(int i=0;i<3;++i) X[i]=NAro[i];
	return;
    };
    inline void GetHAGC(double X[3]) const{//Get Hbond Acceptor Geometric Center
	for(int i=0;i<3;++i) X[i]=AFP::HAGC[i];
	return;
    };
    inline void GetHDGC(double X[3]) const{//Get Hbond Donor Geometric Center
	for(int i=0;i<3;++i) X[i]=AFP::HDGC[i];
	return;
    };
    inline void GetAroGC(double X[3]) const{//Get Aromatic Geometric Center
	for(int i=0;i<3;++i) X[i]=AFP::AroGC[i];
	return;
    };
    inline void GetIoGC(double X[3]) const{//Get Ion Geometric Center
	for(int i=0;i<3;++i) X[i]=AFP::IoGC[i];
	return;
    };
//Arithmetic
    friend int operator + (const AFP&, const AFP&);
private:
//Interaction definitions
    static double Hdist;//H-bond distance
    static double Hangl;//H-bond angle
    static double Hdngl;//H-bond angle
    static double PSdist;//Pi stacking distance
    static double PSangl;//Pi stacking angle
    static double PSdngl;//Pi stacking angle
    static double EFdist;//Edge to face distance
    static double EFangl;//Edge to face angle
    static double EFdngl;//Edge to face angle
    static double Hydist;//Hydrophibic contact distance
    static double Iondst;//Ionic interaction
//
    static unsigned int TopPrime;//maximal prime number is less than that
    static map<int,int> PrimNbre;//Prime number list 
//Methods
    static bool LcloRng;//Aro. inter. on local atom (0) or ring CG (1) pos.
//Kind of potential interaction
    bool IsHD;//Is an H-bond donnor
    bool IsHA;//Is an H-bond acceptor
    bool IsAr;//Is an Aromatic
    bool IsHy;//Is Hydrophobe
    bool IsCat;//Is a formal cation
    bool IsAnn;//Is a formal anion
//interaction properties
    double HAGC[3],HDGC[3],AroGC[3],IoGC[3],HyGC[3];
    double HD[3];
    double NAro[3];
//Tools
    void HDFind(OEMolBase &conf, OEAtomBase *OEA_D, OEAtomBase *OEA_H);
    void HAFind(OEMolBase &conf, OEAtomBase *OEA_A);
    void NAroFind_Local(OEMolBase &Ring);
    inline void HyFind(OEMolBase &conf, OEAtomBase *OEA_Hy){
	conf.GetCoords(OEA_Hy,AFP::HyGC);
	return;
    };
    inline void IonFind(OEMolBase &conf, OEAtomBase *OEA_Ion){
	conf.GetCoords(OEA_Ion,AFP::IoGC);
	return;
    };
};
#endif
