#ifndef SMLSTRNG_HPP
#define SMLSTRNG_HPP
#include "oechem.h"
#include "oesystem.h"
using namespace OEChem;
using namespace OESystem;
using namespace OEMath;
using namespace std;

class SmlstRng{
/****************************************************/
/* Smallest ring associated to an atom.             */
/* G. Marcou                                        */
/****************************************************/
public:
    //Constructor
    SmlstRng();
    void Reset();//Reset private members
    inline OEMol GetSmlstRng(){//Get the ring
	return(ring);
    };
    inline int GetSeekId(){//Atom Idx seeked
	return(SeekId);
    };
    inline int GetMaxCnt(){//Maximum ring size to be found
	return(MaxCnt);
    };
    inline void SetSeekId(const int &i){//Atom Idx seeked
	SeekId=i;
	return;
    };
    inline void SetMaxCnt(const int &i){//Maximum ring size to be found
	MaxCnt=i;
	return;
    };
    void SetSearch(OEAtomBase &atom);//Setting the search for an atom
    bool FndARng(OEAtomBase *atom, unsigned int PrevId);//Find the ring
    void CleanRng();//The first and last atom of a seeked ring is the same
    void RngGC(double GC[3]);//Geometric center of the ring
    void RngNml(double GC[3], double N[3]);//Normal to the ring, evaluate the Geometric Center also
private:
    OEMol ring;//Storage
    unsigned int CntRng;//Counter to check parsed ring size
    unsigned int SeekId;//Atom Idx seeked
    unsigned int MaxCnt;//Maximum ring size to be found
    bool found;//Was the smallest ring found?
};
#endif
