#ifndef MAFP_HPP
#define MAFP_HPP
#include <ostream>
#include <iomanip>
#include <algorithm>
#include "AFP.hpp"
#include "misc.hpp"
#include "oechem.h"
#include "oesystem.h"
using namespace OEChem;
using namespace OESystem;
using namespace std;

class MAFP{
/****************************************************/
/* Molecular by Atom Interaction Finger Print.      */
/* G. Marcou                                        */
/****************************************************/
public:
    MAFP();
    MAFP(OEMol &mol);
    void InitAtmBVPos();
    inline void SetIMolFP(OEBitVector& OEBV){
	if(MAFP::AtmBVPos.size()==0)
	    InitAtmBVPos();
	IMolFP=OEBV;
	return;
    };
    void SetIMolFP(OEMol&);
    inline void SetLig(OEMol& mol){
	MAFP::lig=mol;
	return;
    };
    inline OEMol GetLig(){
	return(MAFP::lig);
    };
    inline OEBitVector GetIMolFP(){
	return(MAFP::IMolFP);
    };
    inline void ResetAtmBVPos(){
	MAFP::AtmBVPos.clear();
    };
    inline void ResetIMolFP(){
	MAFP::IMolFP.ClearBits();
    };
    inline map<string,int> GetAtmBVPos(){
      return(MAFP::AtmBVPos);
    };
    inline void SetAtmBVSize(unsigned int i){
	MAFP::AtmBVSize=i;
	return;
    };
    inline int GetAtmBVSize(){
	return(MAFP::AtmBVSize);
    };
private:
    map<string,int> AtmBVPos;//Map Atm. to pos. in IMolFP
    OEMol lig;//Ligand bounded to the Interaction Finger Print
    OEBitVector IMolFP;//OEBitVector of the Finger Print
    static unsigned int AtmBVSize;//Bit vector size per residue
};
//
inline ostream& operator << (ostream &strm, MAFP &MolFP){
    int i,iprnt;
    OEBitVector OEBV;
//
    map<string,int> BVPos;
    map<string,int>::iterator _BVPos;
    BVPos=MolFP.GetAtmBVPos();
    for(i=0;i<int(BVPos.size());++i){
//Print residue references in same order as the OEBitVector
      _BVPos=BVPos.begin();
      while((_BVPos!=BVPos.end())&&(_BVPos->second!=int(i)))
	_BVPos++;
      strm << "|" << setw (MolFP.GetAtmBVSize()-1) << _BVPos->first;
    };
    strm << endl;
//
//Display the OEBitVector
    OEBV=MolFP.GetIMolFP();
    for(iprnt=0;iprnt<int(OEBV.GetSize());++iprnt)
	strm << OEBV.IsBitOn(iprnt);
    strm << endl;
    return(strm);
};
//
inline istream& operator >> (istream &strm, MAFP &MolFP){
    int i;
    char c;
    OEBitVector OEBV;
//
    if(!strm.good()) return(strm);
    c='x';
    i=0;
    while((c!='\n')&&(strm.good())){
	c=strm.get();
	if(c=='0'){
	    OEBV.SetBitOff(i);
	    i++;
	} else if(c=='1'){
	    OEBV.SetBitOn(i);
	    i++;
	};
    };
    MolFP.SetIMolFP(OEBV);
//
    return(strm);
};
#endif
