#ifndef ExtMFP_HPP
#define ExtMFP_HPP
#include "MFP.hpp"
#include "ExtAFP.hpp"
using namespace OEChem;
using namespace OESystem;
using namespace std;

class ExtMFP:public MFP{
/****************************************************/
/* Molecular Interaction Finger Print.              */
/* G. Marcou                                        */
/****************************************************/
public:
    ExtMFP(){
 	AFP::SetTopPrime(32);
	MFP::SetResBVSize(ExtAFP::GetBitNbre());    
	cout << "Top Prime: " << AFP::GetTopPrime() << endl;
	cout << " Residue Bit Vector Size: " << MFP::GetResBVSize() << endl;
	MFP::IMolFPClear();
    };
    ExtMFP(OEMol &mol):MFP(mol){
 	AFP::SetTopPrime(32);
	MFP::SetResBVSize(ExtAFP::GetBitNbre());    
	cout << "Top Prime: " << AFP::GetTopPrime() << endl;
	cout << " Residue Bit Vector Size: " << MFP::GetResBVSize() << endl;
	MFP::IMolFPClear();
    };
    void SetIMolFP(OEMol &lig);
private:
};
//
inline ostream& operator << (ostream &strm, ExtMFP &MolFP){
    int i,iprnt;
    OEBitVector OEBV;
//
    map<string,int> BVPos;
    map<string,int>::iterator _BVPos;
    BVPos=MolFP.GetResBVPos();
    for(i=0;i<int(BVPos.size());++i){
//Print residue references in same order as the OEBitVector
      _BVPos=BVPos.begin();
      while((_BVPos!=BVPos.end())&&(_BVPos->second!=int(i)))
	_BVPos++;
      strm << "|" << setw (MolFP.GetResBVSize()-1) << _BVPos->first;
    };
    strm << endl;
//
//Display the OEBitVector
    OEBV=MolFP.GetIMolFP();
    for(iprnt=0;iprnt<int(OEBV.GetSize());++iprnt)
	strm << OEBV.IsBitOn(iprnt);
    strm << endl;
    return(strm);
};
#endif
