#ifndef EXTAFP_HPP
#define EXTAFP_HPP
#include "AFP.hpp"
#include "misc.hpp"
#include "ExtPropConstants.hpp"
#include "SmlstRng.hpp"
using namespace OEChem;
using namespace OEMath;
using namespace OESystem;
using namespace std;

class ExtAFP:public AFP{
/****************************************************/
/* Extended Atomic Finger Print.                    */
/* G. Marcou                                        */
/****************************************************/
public:
    ExtAFP();
//     void ExtAFP::SetIsHy(OEAtomBase*);
// /************************************************************/
// /* Extension of Hydrophobic atom definition.                */
// /* G. Marcou                                                */
// /************************************************************/
//     void ExtAFP::SetIsHA(OEAtomBase*);
// /************************************************************/
// /* Extension of H-bond acceptor definition.                 */
// /* G. Marcou                                                */
// /************************************************************/
    static inline void SetWHBdist(double d){
/************************************************************/
/* Set Weak Hydrogen bond distance.                         */
/* G. Marcou                                                */
/************************************************************/
	ExtAFP::WHBdist=d;
	return;
    };
    static inline double GetWHBdist(){
/************************************************************/
/* Get Weak Hydrogen bond distance.                         */
/* G. Marcou                                                */
/************************************************************/
	return(ExtAFP::WHBdist);
    };
    static inline void SetWHBangle(double d){
/************************************************************/
/* Set Weak Hydrogen bond angle.                            */
/* G. Marcou                                                */
/************************************************************/
	ExtAFP::WHBangle=d;
	return;
    };
    static inline double GetWHBangle(){
/************************************************************/
/* Get Weak Hydrogen bond angle.                            */
/* G. Marcou                                                */
/************************************************************/
	return(ExtAFP::WHBangle);
    };
    static inline void SetWHBdngle(double d){
/************************************************************/
/* Set Weak Hydrogen bond deviation angle.                  */
/* G. Marcou                                                */
/************************************************************/
	ExtAFP::WHBdngle=d;
	return;
    };
    static inline double GetWHBdngle(){
/************************************************************/
/* Get Weak Hydrogen bond deviation angle.                  */
/* G. Marcou                                                */
/************************************************************/
	return(ExtAFP::WHBdngle);
    };
    static inline void SetPiCatdist(double d){
/************************************************************/
/* Set Pi-Cation distance.                                  */
/* G. Marcou                                                */
/************************************************************/
	ExtAFP::PiCatdist=d;
	return;
    };
    static inline double GetPiCatdist(){
/************************************************************/
/* Get Pi-Cation distance.                                  */
/* G. Marcou                                                */
/************************************************************/
	return(ExtAFP::PiCatdist);
    };
    static inline void SetPiCatangle(double d){
/************************************************************/
/* Set Pi-Cation angle.                                     */
/* G. Marcou                                                */
/************************************************************/
	ExtAFP::PiCatangle=d;
	return;
    };
    static inline double GetPiCatangle(){
/************************************************************/
/* Get Pi-Cation angle.                                     */
/* G. Marcou                                                */
/************************************************************/
	return(ExtAFP::PiCatangle);
    };
    static inline void SetPiCatdngle(double d){
/************************************************************/
/* Set Pi-Cation deviation angle.                           */
/* G. Marcou                                                */
/************************************************************/
	ExtAFP::PiCatdngle=d;
	return;
    };
    static inline double GetPiCatdngle(){
/************************************************************/
/* Get Pi-Cation deviation angle.                           */
/* G. Marcou                                                */
/************************************************************/
	return(ExtAFP::PiCatdngle);
    };
    static inline void SetMetaldist(double d){
/************************************************************/
/* Set coordination metal ditance.                          */
/* G. Marcou                                                */
/************************************************************/
	ExtAFP::Metaldist=d;
	return;
    };
    static inline double GetMetaldist(){
/************************************************************/
/* Get coordination metal ditance.                          */
/* G. Marcou                                                */
/************************************************************/
	return(ExtAFP::Metaldist);
    };
    inline void SetIsWHBA(bool b){
/************************************************************/
/* Set if atom is Weak Hydrogen bond acceptor.              */
/* A weak H-bond acceptor is either a neutral sulfur or a   */
/* pi-electronic cloud (carbon sp, sp2 or aromatic).        */
/* G. Marcou                                                */
/************************************************************/
	ExtAFP::IsWHBA=b;
	return;
    };
    void SetIsWHBA(OEAtomBase*);
    inline void SetIsWHBD(bool b){
/************************************************************/
/* Set if atom is Weak Hydrogen bond donor.                 */
/* A weak H-bond donor is an hydrogen covalently bond to    */
/* either an sp, sp2 or aromatic carbon.                    */
/* G. Marcou                                                */
/************************************************************/
	ExtAFP::IsWHBD=b;
	return;
    };
    void SetIsWHBD(OEAtomBase*);
    inline bool GetIsWHBA() const{
/************************************************************/
/* Get if atom is Weak Hydrogen bond acceptor.              */
/* G. Marcou                                                */
/************************************************************/
	return(ExtAFP::IsWHBA);
    };
    inline bool GetIsWHBD() const{
/************************************************************/
/* Get if atom is Weak Hydrogen bond donor.                 */
/* G. Marcou                                                */
/************************************************************/
	return(ExtAFP::IsWHBD);
    };
    inline void SetWGC(double U[3]){
/************************************************************/
/* Set the geometric center of weak hydrogen bond           */
/* interaction.                                             */
/* G. Marcou                                                */
/************************************************************/
	for(int i=0; i<3; ++i)
	    ExtAFP::WGC[i]=U[i];
	return;
    };
    inline void GetWGC(double U[3]) const{
/************************************************************/
/* Get the geometric center of weak hydrogen bond           */
/* interaction.                                             */
/* G. Marcou                                                */
/************************************************************/
	for(int i=0; i<3; ++i)
	    U[i]=ExtAFP::WGC[i];
	return;
    };
    inline void SetWHDdir(double U[3]){
/************************************************************/
/* Set the directionality of weak hydrogen bond interaction.*/
/* G. Marcou                                                */
/************************************************************/
	for(int i=0; i<3; ++i)
	    ExtAFP::WHdir[i]=U[i];
	return;
    };
    inline void GetWHDdir(double U[3]) const{
/************************************************************/
/* Get the directionality of weak hydrogen bond interaction.*/
/* G. Marcou                                                */
/************************************************************/
	for(int i=0; i<3; ++i)
	    U[i]=ExtAFP::WHdir[i];
	return;
    };
    inline void SetPiCatGC(double U[3]){
/************************************************************/
/* Set the geometric center of Pi-Cation interaction.       */
/* G. Marcou                                                */
/************************************************************/
	for(int i=0; i<3; ++i)
	    ExtAFP::PiCatGC[i]=U[i];
	return;
    };
    inline void GetPiCatGC(double U[3]) const{
/************************************************************/
/* Get the geometric center of Pi-Cation interaction.       */
/* G. Marcou                                                */
/************************************************************/
	for(int i=0; i<3; ++i)
	    U[i]=ExtAFP::PiCatGC[i];
	return;
    };
    inline void SetPiCatdir(double U[3]){
/************************************************************/
/* Set the directionality of Pi-Cation interaction.         */
/* G. Marcou                                                */
/************************************************************/
	for(int i=0; i<3; ++i)
	    ExtAFP::PiCatdir[i]=U[i];
	return;
    };
    inline void GetPiCatdir(double U[3]) const{
/************************************************************/
/* Get the directionality of Pi-Cation interaction.         */
/* G. Marcou                                                */
/************************************************************/
	for(int i=0; i<3; ++i)
	    U[i]=ExtAFP::PiCatdir[i];
	return;
    };
    inline void SetIsMetal(bool b){
/************************************************************/
/* Set if atom is a metal.                                  */
/* A metal is either a Mg, Ca, Mn, Fe, Co, Ni, Zn, Cu or Cd */
/* G. Marcou                                                */
/************************************************************/
	ExtAFP::IsMetal=b;
	return;
    };
    void SetIsMetal(OEAtomBase*);
    inline bool GetIsMetal() const{
/************************************************************/
/* Get if atom is a metal.                                  */
/* G. Marcou                                                */
/************************************************************/
	return(ExtAFP::IsMetal);
    };
    inline void SetMetalGC(double GC[3]){
/************************************************************/
/* Set the geometric center of metal interaction            */
/* G. Marcou                                                */
/************************************************************/
	for(int i=0; i<3; ++i)
	    ExtAFP::MetalGC[i]=GC[i];
	return;
    };
    inline void GetMetalGC(double GC[3]) const{
/************************************************************/
/* Get the geometric center of metal interaction            */
/* G. Marcou                                                */
/************************************************************/
	for(int i=0; i<3; ++i)
	    GC[i]=ExtAFP::MetalGC[i];
	return;
    };
    void SetProperties(OEAtomBase*);//Set all properties
    void PropReset();//Reset properties
    void SetDirections(OEMolBase&, OEAtomBase*);//Set Geometries
    static inline unsigned int GetBitNbre(){
	unsigned int cpt;
	cpt=AFP::GetBitNbre();
	if(ExtAFP::GetWHBdist()>0)
	    cpt+=2;
	if(ExtAFP::GetPiCatdist()>0)
	    cpt++;
	if(ExtAFP::GetMetaldist()>0)
	    cpt++;
	return(cpt);
    };
    friend int operator + (const ExtAFP&, const ExtAFP&);//Find interactions
private:
    bool IsWHBA,IsWHBD,IsMetal;
    static double WHBdist;
    static double WHBangle;
    static double WHBdngle;
    static double PiCatdist;
    static double PiCatangle;
    static double PiCatdngle;
    static double Metaldist;
    double WGC[3],WHdir[3];
    double PiCatGC[3],PiCatdir[3];
    double MetalGC[3];
    void MolGC(OEMolBase&, double GC[3]);
/************************************************************/
/* Set GC on the gravity center of the Pi-electronic cloud. */
/* NOTE: This method maybe moved in more relevant classes   */
/* future release of the library.                           */
/* G. Marcou                                                */
/************************************************************/
    inline void WHAFind(OEMolBase &mol){
/************************************************************/
/* Find and set GC of weak Hbond interaction center         */
/* G. Marcou                                                */
/************************************************************/
	double GC[3];
	ExtAFP::MolGC(mol,GC);
	ExtAFP::SetWGC(GC);
	return;
    };
    void WHDFind(OEMolBase&, OEAtomBase*, OEAtomBase*);
/************************************************************/
/* Find the D-H vector and set GC the weak Hbond            */
/* interaction center.                                      */
/* G. Marcou                                                */
/************************************************************/
    inline void CatFind(OEMolBase& mol, OEAtomBase* X){
/************************************************************/
/* Find and set GC of Cation interaction center.            */
/* G. Marcou                                                */
/************************************************************/
	double GC[3];
	mol.GetCoords(X,GC);
	ExtAFP::SetPiCatGC(GC);
	return;
    };
    inline void MetalFind(OEMolBase& mol, OEAtomBase* X){
/************************************************************/
/* Find and set GC of metal interaction center.             */
/* G. Marcou                                                */
/************************************************************/
	double GC[3];
	mol.GetCoords(X,GC);
	ExtAFP::SetMetalGC(GC);
	return;
    };
};
#endif
