#ifndef BAYES_HPP
#define BAYES_HPP
#include <ostream>
#include <cmath>
#include "oechem.h"
#include "oesystem.h"
using namespace OEChem;
using namespace OEMath;
using namespace OESystem;
using namespace std;
class Bayes{
/************************************************************/
/* Class for learning machine application to finger print   */
/* This class is a prototype. The structure shall change    */
/* deeply in future release.                                */
/* G. Marcou                                                */
/************************************************************/
public:
    Bayes();
    void Reset();
    inline void SetAlgo(int i){
/************************************************************/
/* Set the algorithm flag                                   */
/* G. Marcou                                                */
/************************************************************/
	Bayes::Algo=i;
	return;
    };
    inline int GetAlgo(){
/************************************************************/
/* Get the algorithm flag                                   */
/* G. Marcou                                                */
/************************************************************/
	return(Bayes::Algo);
    };
    void Training(OEBitVector, bool);
    void SetInfereXiao();
    void SetInfereBayes();
    inline void SetOnSupport(vector<double> Supp){
/************************************************************/
/* Set the OnSupport vector                                 */
/* G. Marcou                                                */
/************************************************************/
	Bayes::OnSupport=Supp;
	return;
    };
    inline void SetOffSupport(vector<double> Supp){
/************************************************************/
/* Set the OnSupport vector                                 */
/* G. Marcou                                                */
/************************************************************/
	Bayes::OffSupport=Supp;
	return;
    };
    void SetSupport();
    inline vector<double> GetOnSupport(){
/************************************************************/
/* Get the OnSupport vector                                 */
/* G. Marcou                                                */
/************************************************************/
	return(Bayes::OnSupport);
    };
    inline vector<double> GetOffSupport(){
/************************************************************/
/* Get the OffSupport vector                                */
/* G. Marcou                                                */
/************************************************************/
	return(Bayes::OffSupport);
    };
    inline void SetOnSupportMin(double m){
/************************************************************/
/* Set the OnSupport min value                              */
/* G. Marcou                                                */
/************************************************************/
	Bayes::OnSupportMin=m;
	return;
    };
    inline void SetOffSupportMin(double m){
/************************************************************/
/* Set the OffSupport min value                             */
/* G. Marcou                                                */
/************************************************************/
	Bayes::OffSupportMin=m;
	return;
    };
    inline double GetOnSupportMin(){
/************************************************************/
/* Get the OnSupport min value                              */
/* G. Marcou                                                */
/************************************************************/
	return(Bayes::OnSupportMin);
    };
    inline double GetOffSupportMin(){
/************************************************************/
/* Get the OffSupport min value                             */
/* G. Marcou                                                */
/************************************************************/
	return(Bayes::OffSupportMin);
    };
    inline void SetOnInfere(vector<double> VI){
/************************************************************/
/* Set the OnInfere vector                                  */
/* G. Marcou                                                */
/************************************************************/
	Bayes::OnInfere=VI;
	return;
    };
    inline void SetOffInfere(vector<double> VI){
/************************************************************/
/* Set the OffInfere vector                                 */
/* G. Marcou                                                */
/************************************************************/
	Bayes::OffInfere=VI;
	return;
    };
    inline vector<double> GetOnInfere(){
/************************************************************/
/* Get the OnInfere vector                                  */
/* G. Marcou                                                */
/************************************************************/
	return(Bayes::OnInfere);
    };
    inline vector<double> GetOffInfere(){
/************************************************************/
/* Get the OffInfere vector                                 */
/* G. Marcou                                                */
/************************************************************/
	return(Bayes::OffInfere);
    };
    double Predict(OEBitVector);
private:
    bool Init;
    int Algo;
    int TotAct,TotInAct,NFeature;
    double OnSupportMin,OffSupportMin;
    vector<double> OnSupport,OffSupport;
    vector<int> OnAct,OnInAct;
    vector<int> OffAct,OffInAct;
    vector<double> OnInfere,OffInfere;
};
#endif
