package fr.u_strasbg.bioinfo_pharma.util;

import fr.u_strasbg.bioinfo_pharma.application.bestGoldScorer.ligand.Position;

public class Search {

	private Position[] positions;
	
    public Search (Position[] positions) {
    	this.positions = positions;
    }
    
    public int Binary(Position threshold){
    	double fitness = threshold.getFitness();
    	int begin = 0;
        int end = this.positions.length - 1;
        int middle;
        while (begin <= end){
            middle = ( begin + end )/2;
            if( this.positions[middle].getFitness() == fitness )
            	return middle;
            else 
              if (this.positions[middle].getFitness() < fitness ) 
              	begin = middle + 1;
              else 
              	end = middle - 1;
        }
        return -1;
    }



}
