package fr.u_strasbg.bioinfo_pharma.application.bestGoldScorer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.foata.nicolas.arguments.ArgException;
import org.foata.nicolas.arguments.Arguer;
import org.foata.nicolas.arguments.ArgumentsDefinition;
import fr.u_strasbg.bioinfo_pharma.application.bestGoldScorer.exception.BGSException;
import fr.u_strasbg.bioinfo_pharma.application.bestGoldScorer.processing.Processor;


public class BestGoldScorer {

	//Constant
	private static final long serialVersionUID = 1L;
	private static final String[] KEEP_VALUES = { "all" , "best" };
	
	//Class Attribut
	public static Logger logger = Logger.getLogger("BestGoldScorer");
	
	//Attributs
	private boolean isHelp;
	private String[] args;
	private String ligandFile;
	private String sizeString;
	private int bundleSize;
	private String keep;
	private String thresholdString;
	private double threshold;
	private String outputScoreFilePath;
	private String outputMol2FilePath;
	private String logLevel;
	private String baseDir;
	private String fileSeparator = System.getProperty("file.separator");
	
	//Constructors
	public BestGoldScorer(String[] args){
		this.args = args;
	}
	
	//Public methods
	public void init() throws BGSException{
		try {
			//Init the logger 
			this.initLogger();
		
			//Loading of the definition of the arguments for this application.
			String fileSeparator = System.getProperty("file.separator");
			
			String homePath = System.getenv("BGS_HOME") ;
			if ( homePath.endsWith(fileSeparator) )
				homePath = homePath.substring(0, homePath.length()-1);
			String defPath = homePath+"/etc/conf/bestGoldScorer.def";
			
			File file = new File( defPath );
			if ( !file.isFile() ){
				throw new BGSException("The file bestGoldScorer.def must be a file !");	
			}
			if ( !file.exists() ){
				throw new BGSException("The file bestGoldScorer.def does not exist.");	
			}
			if ( !file.canRead() ){
				throw new BGSException("You are not allowed to read that file called mbti.def.");	
			}
			ArgumentsDefinition argsDef = ArgumentsDefinition.load(file,"org.foata.nicolas.arguments.ArguerAdapter");
			Arguer arguer = argsDef.createArguer();
			
			//An exception is raised in the event of error
			arguer.matches(this.args);
			
			//Recovery of parameters
					//The base dir
			List<String> dirs = arguer.get("directory");
			if ( dirs != null && dirs.size() > 0){
				this.baseDir = (String)dirs.get(0) ;
			} else {
				this.baseDir = "";
			}
			if ( this.baseDir == null || this.baseDir.equals("") ){
				this.baseDir = "";
			} else if ( this.baseDir.endsWith(fileSeparator) )
				this.baseDir = this.baseDir.substring(0, this.baseDir.length()-1);
			
			
					//The log file
			List<String> logs = arguer.get("logLevel");
			if ( logs != null && logs.size() > 0){
				this.logLevel = (String)logs.get(0) ;
			} else {
				this.logLevel = "warning";
			}
			if ( this.logLevel == null || this.logLevel.equals("") ){
				this.logLevel = "warning";
			}
			BestGoldScorer.logger.setLevel( this.getLogLevel( this.logLevel ));
	
			String outputFilesPath = homePath+"/output/results/";
					//The score file
			List<String> scores = arguer.get("score");
			if ( scores != null && scores.size() > 0){
				this.outputScoreFilePath = (String)scores.get(0) ;
			} else {
				this.outputScoreFilePath = "scores.csv";
			}
			if ( this.outputScoreFilePath == null || this.outputScoreFilePath.equals("") ){
				this.outputScoreFilePath = "scores.csv";
			}
					//The mol2 file
			List<String> mol2s = arguer.get("mol2");
			if ( mol2s != null && mol2s.size() > 0){
				this.outputMol2FilePath = (String)mol2s.get(0) ;
			} else {
				this.outputMol2FilePath = "poses.mol2" ;
			}
			if ( this.outputMol2FilePath == null || this.outputMol2FilePath.equals("") ){
				this.outputMol2FilePath = "poses.mol2";
			}
					//The bundle size
			List<String> sizes = arguer.get("bundle");
			if ( sizes != null && sizes.size() > 0){
				this.sizeString = (String)sizes.get(0) ;
			} else {
				this.sizeString = "5";
			}
			try {
				this.bundleSize = Integer.valueOf(this.sizeString).intValue();
			} catch ( ClassCastException e ){
				throw new BGSException ("The option 'size' must be an integer."+e.getMessage());
			} catch ( Exception e){
				throw new BGSException ("The option 'size' must be an integer."+e.getMessage());
			}
					//The ligandFile
			List<String> ligandFiles = arguer.get("list");
			if ( ligandFiles != null && ligandFiles.size() > 0){
				this.ligandFile = (String)ligandFiles.get(0);
			} else {
				if ( this.baseDir == null || this.baseDir.equals("") )
					this.ligandFile = "Lig.list";
				else
					this.ligandFile = /*this.baseDir + this.fileSeparator + */"Lig.list";
			}
				
				    //Keep poses
			List<String> keeps = arguer.get("keep");
			if ( keeps != null && keeps.size() > 0){
				this.keep = (String)keeps.get(0);
			} else {
				this.keep = "all";
			}
			boolean isGoodKeepValue = false;
			for ( int i = 0; i < KEEP_VALUES.length ; i++){
				if ( this.keep != null && this.keep.equals( KEEP_VALUES[i] ) ){
					isGoodKeepValue = true;
				}
			}
			if ( !isGoodKeepValue ){
				throw new BGSException ("The option 'keep' take only the following values : all , best. ");
			}
					//Threshold
			List<String> thresholds = arguer.get("threshold");
			if ( thresholds != null && thresholds.size() > 0){
				this.thresholdString = (String)thresholds.get(0);
			} else {
				this.thresholdString = ""+Processor.NO_THRESHOLD;
			}
			try {
				if ( this.thresholdString != null && !this.thresholdString.equals(""))
					this.threshold = Double.valueOf(this.thresholdString).doubleValue();
				else 
					this.threshold = Processor.NO_THRESHOLD;
			} catch ( ClassCastException e ){
				throw new BGSException ("The option 'threshold' must be a double."+e.getMessage());
			} catch ( Exception e){
				throw new BGSException ("The option 'threshold' must be a double."+e.getMessage());
			}
			
					//Do we display the help
			this.isHelp = arguer.containsKey("help");
			
			//Checking if there is the minimum number of args, if we don't use the Graphic User Interface
			/*if (  !this.isHelp  || ){
				this.displayHelp();
				throw new BGSException("The minimum arguments to put without GUI is --help or --interface ");
			}*/
		} catch (ArgException e) {
			this.displayHelp();
			throw new BGSException("ArgException : "+e.getMessage());
		}
	}
	public void starts() throws BGSException{
		if ( isHelp ){
			this.displayHelp();
		} else {
			Processor processor = new Processor();
			if ( this.keep.equals("all") )
				processor.setKeep( Processor.KEEP_ALL );
			else if ( this.keep.equals("best") )
				processor.setKeep( Processor.KEEP_BEST );
			processor.setBundleSize( this.bundleSize );
			processor.setThreshold( this.threshold );
			processor.setOuputScoreFilePath( this.outputScoreFilePath );
			processor.setOutputMol2FilePath( this.outputMol2FilePath );
			processor.setInputLigandFilePath( this.ligandFile );
			if ( this.baseDir != null && this.baseDir.equals("") )
				processor.setBaseDir( this.baseDir );
			else
				processor.setBaseDir( this.baseDir + this.fileSeparator );
			processor.setPrefixDir( "db" );
			processor.setSubPrefixDir( "db_" );
			processor.setSubSuffixDir( "_m" );
			processor.setMolFileRankExtension( ".rnk" ) ;
			processor.process();
		}	
		BestGoldScorer.logger.exiting("Main","starts");
	}
	private void initLogger() throws BGSException{
		//Logger
		FileHandler fh = null;
		FileHandler fh2 = null;
		try {
			String fileSeparator = System.getProperty("file.separator");
			String homePath = System.getenv("BGS_HOME") ;
			if ( homePath.endsWith(fileSeparator) )
				homePath = homePath.substring(0, homePath.length()-1);
			String logFilePath = homePath+"/output/log/bestGoldScorer.log";
			String logDirPath = homePath+"/output/log/";
			File dir = new File( logDirPath );
			if ( !dir.exists() || !dir.isDirectory() )
				throw new BGSException("Impossible to find the log directory.");
			fh2 = new FileHandler( logFilePath );
			//fh = new FileHandler("./bestGoldScorer.log",10000,1,true);
		} catch (SecurityException e) {
			throw new BGSException("A SecurityException with the fileHandler occured. "+e.getMessage());
		} catch (IOException e) {
			throw new BGSException("An IOException with the fileHandler occured. "+e.getMessage());
		}
		BestGoldScorer.logger.addHandler(fh2);
		BestGoldScorer.logger.setLevel(Level.INFO);
	}
	
	private void setLogLevel() throws BGSException{
		BestGoldScorer.logger.entering("Main","setLogLevel");
		BestGoldScorer.logger.setLevel(Level.WARNING);
		BestGoldScorer.logger.exiting("LogP","setLogLevel");
	}
	
	private void displayHelp() throws BGSException{
		BestGoldScorer.logger.entering("Main","displayHelp");
		
		String fileSeparator = System.getProperty("file.separator");

		String homePath = System.getenv("BGS_HOME") ;
		if ( homePath.endsWith(fileSeparator) )
			homePath = homePath.substring(0, homePath.length()-1);
		String usePath = homePath+"/etc/conf/bestGoldScorer.use";
		
		File commandFile = new File( usePath);
		if ( !commandFile.exists() ){
			throw new BGSException("The file bestGoldScorer.use does not exist.");	
		}
		if ( !commandFile.canRead() ){
			throw new BGSException("You are not allowed to read that file called bestGoldScorer.use.");	
		}
		FileInputStream fis;
		try {
			fis = new FileInputStream( commandFile );
			InputStreamReader isr = new InputStreamReader( fis, "UTF-8");
			BufferedReader br = new BufferedReader( isr );
			String line = null;
			while ( (line = br.readLine()) != null ){
				System.out.println(line);
			}
			br.close();
			isr.close();
			fis.close();
		} catch (FileNotFoundException e1) {
			throw new BGSException("FileNotFoundException : "+e1.getMessage());
		} catch (UnsupportedEncodingException e1) {
			throw new BGSException("UnsupportedEncodingException : "+e1.getMessage());
		} catch (IOException e1) {
			throw new BGSException("IOException : "+e1.getMessage());
		} catch (Exception e){
			throw new BGSException("Unknown Exception : "+e.getMessage());
		}
		BestGoldScorer.logger.exiting("Main","displayHelp");
	}
	
	
	//Main method
	public static void main(String[] args) {
		
		try {
			BestGoldScorer bgs = new BestGoldScorer(args);
			bgs.init();	
			bgs.starts();
		} catch (BGSException e) {
			System.err.println("BGSException : "+e.getMessage());
			System.exit(1);
		}
		System.exit(0);
	}

	private Level getLogLevel( String logLevelString ){
		if ( logLevelString == null || logLevelString.equalsIgnoreCase("") || logLevelString.equals("info") )
			return Level.INFO;
		return Level.WARNING;
	}
}
