package org.foata.nicolas.arguments;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.ArrayList;
import java.util.Properties;

public class ArgumentsDefinition {

	// Attributs
	private static ArgumentsDefinition instance;

	private List<ArgOption> options;

	private String arguerName;

	// Constructors
	private ArgumentsDefinition(File file, String arguerName)
			throws ArgException {
		if (file.exists()) {
			if (file.canRead()) {
				this.arguerName = arguerName;
				recovery(file);
			} else {
				throw new ArgException((new StringBuilder(
						"Your are not allowed to read this file (")).append(
						file.getName()).append(").").toString());
			}
		} else {
			throw new ArgException((new StringBuilder("This file named '"))
					.append(file.getName()).append(" does not exist.")
					.toString());
		}
	}

	// Methods
	public static ArgumentsDefinition load(File file, String arguerName)
			throws ArgException {
		if (instance == null)
			return new ArgumentsDefinition(file, arguerName);
		else
			return instance;
	}

	public List getArgOptions() {
		return options;
	}

	public Arguer createArguer() throws ArgException {
		Arguer arguer = null;
		try {
			Class c = Class.forName(arguerName);
			Object object = c.newInstance();
			if (!(object instanceof Arguer))
				throw new ArgException((new StringBuilder("This arguerName "))
						.append(arguerName).append(" is not an Arguer")
						.toString());
			arguer = (Arguer) object;
			arguer.links(this);
		} catch (ClassNotFoundException e) {
			throw new ArgException((new StringBuilder(
					"ClassNotFoundException : ")).append(e.getMessage())
					.toString());
		} catch (InstantiationException e) {
			throw new ArgException((new StringBuilder(
					"InstantiationException : ")).append(e.getMessage())
					.toString());
		} catch (IllegalAccessException e) {
			throw new ArgException((new StringBuilder(
					"IllegalAccessException : ")).append(e.getMessage())
					.toString());
		}
		return arguer;
	}

	private void recovery(File file) throws ArgException {
		FileInputStream fis = null;
		try {
			fis = new FileInputStream(file);
		} catch (FileNotFoundException e) {
			throw new ArgException((new StringBuilder(
					"FileNotFoundException : ")).append(e.getMessage())
					.toString());
		}
		Properties props = new Properties();
		try {
			props.load(fis);
			int argsNb = Integer.valueOf(props.getProperty("arguments.nb"))
					.intValue();
			options = new ArrayList<ArgOption>();
			ArgOption option = null;
			for (int i = 0; i < argsNb; i++) {
				option = new ArgOption();
				option.setShortName(props.getProperty((new StringBuilder(
						"arguments.")).append(i).append(".short-name")
						.toString()));
				option.setLongName(props.getProperty((new StringBuilder(
						"arguments.")).append(i).append(".long-name")
						.toString()));
				option.setNbParameters(Integer.valueOf(
						props.getProperty((new StringBuilder("arguments."))
								.append(i).append(".param-nb").toString()))
						.intValue());
				options.add(option);
			}

		} catch (InvalidPropertiesFormatException e) {
			throw new ArgException((new StringBuilder(
					"InvalidPropertiesFormatException : ")).append(
					e.getMessage()).toString());
		} catch (IOException e) {
			throw new ArgException((new StringBuilder("IOException : "))
					.append(e.getMessage()).toString());
		} catch (Exception e) {
			throw new ArgException((new StringBuilder("ArgException : "))
					.append(e.getMessage()).toString());
		}
	}

}