package org.foata.nicolas.arguments;

import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.ArrayList;
import java.util.Hashtable;

public class ArguerAdapter implements Arguer {

	// Constructor
	public ArguerAdapter() {
		this.hash = new Hashtable<String, List<String>>();
	}

	// Specific methods
	public void links(ArgumentsDefinition argsDef) {
		this.argsDef = argsDef;
	}

	public boolean matches(String args[]) throws ArgException {
		for (int argIndex = 0; argIndex < args.length;)
			if (args[argIndex].matches("^-{1}[a-zA-Z_]+")) {
				String shortOptions = args[argIndex].substring(1,
						args[argIndex].length());
				int shortOptionsNb = shortOptions.length();
				for (int subOptionIndex = 0; subOptionIndex < shortOptionsNb; subOptionIndex++) {
					boolean find = false;
					int indexOptions = 0;
					ArgOption option = null;
					List options;
					for (options = argsDef.getArgOptions(); indexOptions < options
							.size()
							&& !find;) {
						option = (ArgOption) options.get(indexOptions);
						if (option.getShortName().equals(
								(new StringBuilder()).append(
										shortOptions.charAt(subOptionIndex))
										.toString()))
							find = true;
						else
							indexOptions++;
					}

					if (indexOptions >= options.size())
						throw new ArgException(
								"An option that you entered does not exist.");
					if (find)
						if (!option.isChecked()) {
							option.setChecked(true);
							if (hash.get(option.getLongName()) == null) {
								ArrayList<String> list = new ArrayList<String>();
								for (int m = 1; m <= option.getNbParameters(); m++)
									if (argIndex + m < args.length)
										list.add(args[argIndex + m]);

								hash.put(option.getLongName(), list);
							} else {
								throw new ArgException(
										"ArgException : hash is null");
							}
							argIndex += option.getNbParameters();
							if (argIndex > args.length)
								throw new ArgException(
										"This command line isn't valid. Options haven't got enough parameters.");
						} else {
							throw new ArgException(
									"This command isn't valid. This parameter was already given.");
						}
				}

				argIndex++;
			} else if (args[argIndex].matches("-{2}[a-zA-Z_]+")) {
				boolean find = false;
				int indexOptions = 0;
				ArgOption option = null;
				List options;
				for (options = argsDef.getArgOptions(); indexOptions < options
						.size()
						&& !find;) {
					option = (ArgOption) options.get(indexOptions);
					if (option.getLongName().equals(
							args[argIndex]
									.substring(2, args[argIndex].length())))
						find = true;
					else
						indexOptions++;
				}

				if (indexOptions >= options.size())
					throw new ArgException(
							"An option that you entered does not exist.");
				if (find) {
					if (!option.isChecked()) {
						option.setChecked(true);
						if (hash.get(option.getLongName()) == null) {
							ArrayList<String> list = new ArrayList<String>();
							for (int m = 1; m <= option.getNbParameters(); m++)
								if (argIndex + m < args.length)
									list.add(args[argIndex + m]);

							this.hash.put(option.getLongName(), list);
						} else {
							throw new ArgException(
									"ArgException : hash is null");
						}
						argIndex += option.getNbParameters();
					} else {
						throw new ArgException(
								"This command line isn't valid. Options haven't got enough parameters.");
					}
					if (argIndex > args.length)
						throw new ArgException(
								"This command line isn't valid. Options haven't got enough parameters.");
				}
				argIndex++;
			} else {
				throw new ArgException(
						"Somewhere a parameter was found whereas an option was awaited.");
			}
		return true;
	}

	public List get(String key) {
		return (List) this.hash.get(key);
	}

	public boolean containsKey(String key) {
		return this.hash.containsKey(key);
	}

	public Enumeration keys() {
		return this.hash.keys();
	}

	public Collection values() {
		return this.hash.values();
	}

	public boolean isEmpty() {
		return this.hash.isEmpty();
	}

	// Attributs
	private ArgumentsDefinition argsDef;

	private Hashtable<String, List<String>> hash;
}