/*
 * Decompiled with CFR 0.152.
 */
package fr.u_strasbg.bioinfo_pharma.application.bestGoldScorer.processing;

import fr.u_strasbg.bioinfo_pharma.application.bestGoldScorer.BestGoldScorer;
import fr.u_strasbg.bioinfo_pharma.application.bestGoldScorer.exception.BGSException;
import fr.u_strasbg.bioinfo_pharma.application.bestGoldScorer.ligand.Ligand;
import fr.u_strasbg.bioinfo_pharma.application.bestGoldScorer.ligand.Position;
import fr.u_strasbg.bioinfo_pharma.util.Short;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Processor {
    public static final double NO_THRESHOLD = -9999.99;
    public static final int KEEP_NONE = -1;
    public static final int KEEP_ALL = 0;
    public static final int KEEP_BEST = 1;
    private int keep;
    private int bundleSize;
    private double threshold;
    private String inputLigandFilePath;
    private String ouputScoreFilePath;
    private String outputMol2FilePath;
    private String baseDir;
    private String prefixDir;
    private String prefixSubDir;
    private String suffixSubDir;
    private String molFileRankExtension = ".rnk";
    private String fileSeparator = System.getProperty("file.separator");
    private int nbOfDirectories;
    private int nbOfLigands;
    private List<Ligand> ligands;
    private Position[] shortedPositions;
    private Position[] finalPositions;
    private int ligandId = 0;

    public Processor() {
        this.setLigands(new ArrayList<Ligand>());
        this.setKeep(-1);
    }

    public int getKeep() {
        return this.keep;
    }

    public int getBundleSize() {
        return this.bundleSize;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public String getPrefixDir() {
        return this.prefixDir;
    }

    public String getSubPrefixDir() {
        return this.prefixSubDir;
    }

    public String getSubSuffixDir() {
        return this.suffixSubDir;
    }

    public String getMolFileRankExtension() {
        return this.molFileRankExtension;
    }

    public String getInputLigandFilePath() {
        return this.inputLigandFilePath;
    }

    public String getOuputScoreFilePath() {
        return this.ouputScoreFilePath;
    }

    public String getOutputMol2FilePath() {
        return this.outputMol2FilePath;
    }

    public void setKeep(int keep) {
        this.keep = keep;
    }

    public void setBundleSize(int bundleSize) {
        this.bundleSize = bundleSize;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setPrefixDir(String prefixDir) {
        this.prefixDir = prefixDir;
    }

    public void setSubPrefixDir(String prefixSubDir) {
        this.prefixSubDir = prefixSubDir;
    }

    public void setSubSuffixDir(String suffixSubDir) {
        this.suffixSubDir = suffixSubDir;
    }

    public void setMolFileRankExtension(String molFileRankExtension) {
        this.molFileRankExtension = molFileRankExtension;
    }

    public void setInputLigandFilePath(String inputLigandFilePath) {
        this.inputLigandFilePath = inputLigandFilePath;
    }

    public void setOuputScoreFilePath(String ouputScoreFilePath) {
        this.ouputScoreFilePath = ouputScoreFilePath;
    }

    public void setOutputMol2FilePath(String outputMol2FilePath) {
        this.outputMol2FilePath = outputMol2FilePath;
    }

    private void setLigands(List<Ligand> ligands) {
        this.ligands = ligands;
    }

    public void process() throws BGSException {
        BestGoldScorer.logger.info("Process is starting ...");
        this.init();
        BestGoldScorer.logger.info("Process is recovering poses ...");
        if (this.keep == 0) {
            this.visitDirectories(0, this.nbOfDirectories, this.nbOfLigands);
        } else {
            this.visitDirectories(1, this.nbOfDirectories, this.nbOfLigands);
        }
        BestGoldScorer.logger.info("Process is sorting data ...");
        this.shortByPositions();
        this.finalPositions = this.keep == 0 && this.getThreshold() != -9999.99 ? this.cutOff() : (this.keep == 1 && this.getThreshold() != -9999.99 ? this.cutOff() : this.shortedPositions);
        this.concat();
        BestGoldScorer.logger.info("Process is finishing ...");
    }

    private void init() throws BGSException {
        this.checkAll();
        this.recoveryOfLigands();
        this.nbOfLigands = this.ligands.size();
        this.nbOfDirectories = this.getNbOfDirectories(this.nbOfLigands);
    }

    private void checkAll() throws BGSException {
        if (this.getKeep() == -1) {
            throw new BGSException("Option 'keep' has not a valid value.");
        }
        if (this.getBundleSize() < 1) {
            throw new BGSException("Option 'size' has not a valid value.");
        }
        if (this.getPrefixDir() == null || this.getPrefixDir().equals("")) {
            throw new BGSException("Option 'prefixDir' has not a valid value.");
        }
        if (this.getSubPrefixDir() == null || this.getPrefixDir().equals("")) {
            throw new BGSException("Option 'subPrefixDir' has not a valid value.");
        }
        if (this.getSubSuffixDir() == null || this.getPrefixDir().equals("")) {
            throw new BGSException("Option 'subSuffixDir' has not a valid value.");
        }
        if (this.getMolFileRankExtension() == null) {
            throw new BGSException("Option 'extension' has not a valid value.");
        }
        this.checkInputFile();
        this.checkOutputFiles();
    }

    private void checkInputFile() throws BGSException {
        if (this.getInputLigandFilePath() == null || this.getInputLigandFilePath().equals("")) {
            throw new BGSException("An input file must be given to the Processor class.");
        }
        File file = new File(String.valueOf(this.baseDir) + this.inputLigandFilePath);
        if (!file.exists()) {
            throw new BGSException("This file named '" + this.baseDir + this.inputLigandFilePath + "' does not exist.");
        }
        if (!file.canRead()) {
            throw new BGSException("You are not allowed to read the file named '" + this.baseDir + this.inputLigandFilePath + "'.");
        }
    }

    private void checkOutputFiles() throws BGSException {
        if (this.getOuputScoreFilePath() == null || this.getOuputScoreFilePath().equals("")) {
            throw new BGSException("A score output file must be given to the Processor class.");
        }
        if (this.getOutputMol2FilePath() == null || this.getOutputMol2FilePath().equals("")) {
            throw new BGSException("A score output file must be given to the Processor class.");
        }
    }

    private void recoveryOfLigands() throws BGSException {
        try {
            File inputFile = new File(String.valueOf(this.baseDir) + this.inputLigandFilePath);
            FileInputStream fis = new FileInputStream(inputFile);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            int ligNb = 0;
            while ((line = br.readLine()) != null) {
                if (line.equals("")) continue;
                Ligand ligand = new Ligand();
                ligand.setNumber(++ligNb);
                ligand.setName(line.trim());
                ligand.setPositions(new ArrayList<Position>());
                this.ligands.add(ligand);
            }
            br.close();
            isr.close();
            fis.close();
        }
        catch (FileNotFoundException e) {
            throw new BGSException("Input file was not found. FileNotFoundException : " + e.getMessage());
        }
        catch (IOException e) {
            throw new BGSException("IOException : " + e.getMessage());
        }
    }

    private int getNbOfDirectories(int nbOfLigands) throws BGSException {
        if (this.bundleSize < 1) {
            throw new BGSException(" Nb of bundle size must be >= 1 ");
        }
        int nbOfDirectories = nbOfLigands / this.bundleSize;
        int modulo = nbOfLigands % this.bundleSize;
        if (modulo > 0) {
            ++nbOfDirectories;
        }
        return nbOfDirectories;
    }

    private void visitDirectories(int mode, int nbOfDirectories, int nbOfLigands) throws BGSException {
        int indexDir = 1;
        while (indexDir <= nbOfDirectories) {
            this.visitSubDirectories(mode, indexDir);
            ++indexDir;
        }
    }

    private void visitSubDirectories(int mode, int indexDir) throws BGSException {
        int nbOfSubDir = this.bundleSize;
        if (indexDir * this.bundleSize > this.nbOfLigands) {
            nbOfSubDir = this.nbOfLigands % this.bundleSize;
        }
        int indexSubDir = 1;
        while (indexSubDir <= nbOfSubDir) {
            this.recoverGoldScoreForASingleLigand(mode, indexDir, indexSubDir);
            ++indexSubDir;
        }
    }

    private void recoverGoldScoreForASingleLigand(int mode, int indexDir, int indexSubDir) throws BGSException {
        this.ligandId = this.getCurrentLigandId(indexDir, indexSubDir);
        Ligand ligand = this.getLigand(this.ligandId);
        Collection<Position> positions = ligand.getPositions();
        Position position = null;
        String[] splitLine = null;
        String sep = "[ ]+";
        String dir = String.valueOf(this.baseDir) + this.prefixDir + indexDir;
        String subDir = String.valueOf(this.prefixSubDir) + indexDir + this.suffixSubDir + indexSubDir;
        String rankFile = String.valueOf(subDir) + this.molFileRankExtension;
        String subDirPath = String.valueOf(dir) + this.fileSeparator + subDir;
        String rankFilePath = String.valueOf(subDirPath) + this.fileSeparator + rankFile;
        try {
            File inputFile = new File(rankFilePath);
            if (inputFile.exists()) {
                FileInputStream fis = new FileInputStream(inputFile);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                int lineNb = 0;
                int rank = 0;
                while ((line = br.readLine()) != null) {
                    ++lineNb;
                    splitLine = line.trim().split(sep);
                    if (splitLine == null || splitLine.length != 7) continue;
                    position = new Position(ligand);
                    position.setNumber(Integer.valueOf(splitLine[0]));
                    position.setFitness(Double.valueOf(splitLine[1]));
                    position.setPath(String.valueOf(subDirPath) + this.fileSeparator + "gold_soln_db_" + indexDir + "_m" + indexSubDir + "_" + splitLine[0] + ".mol2");
                    position.setRank(++rank);
                    positions.add(position);
                    if (mode == 1) break;
                }
                br.close();
                isr.close();
                fis.close();
            } else {
                BestGoldScorer.logger.warning("The following path '" + rankFilePath + "' does not exist !");
            }
        }
        catch (FileNotFoundException e) {
            throw new BGSException("Input file was not found. FileNotFoundException : " + e.getMessage());
        }
        catch (IOException e) {
            throw new BGSException("IOException : " + e.getMessage());
        }
    }

    private int getCurrentLigandId(int dirNb, int subDirNb) {
        return (dirNb - 1) * this.bundleSize + subDirNb;
    }

    private Ligand getLigand(int id) throws BGSException {
        for (Ligand ligand : this.ligands) {
            if (ligand.getNumber() != id) continue;
            return ligand;
        }
        throw new BGSException("Ligand with the following id '" + id + "' was not found.");
    }

    private void shortByPositions() {
        ArrayList<Position> recordList = new ArrayList<Position>();
        for (Ligand ligand : this.ligands) {
            Collection<Position> positions = ligand.getPositions();
            for (Position position : positions) {
                recordList.add(position);
            }
        }
        Object[] objects = recordList.toArray();
        Position[] records = new Position[objects.length];
        int i = 0;
        while (i < objects.length) {
            records[i] = (Position)objects[i];
            ++i;
        }
        Short.insertion(records, 0, records.length - 1);
        this.shortedPositions = records;
    }

    private Position[] cutOff() {
        ArrayList<Position> cutOffPositionList = new ArrayList<Position>();
        int i = 0;
        while (i < this.shortedPositions.length) {
            if (!(this.shortedPositions[i].getFitness() >= this.threshold)) break;
            cutOffPositionList.add(this.shortedPositions[i]);
            ++i;
        }
        Object[] objects = cutOffPositionList.toArray();
        Position[] cutOffPosition = new Position[objects.length];
        int i2 = 0;
        while (i2 < objects.length) {
            cutOffPosition[i2] = (Position)objects[i2];
            ++i2;
        }
        Short.insertion(cutOffPosition, 0, cutOffPosition.length - 1);
        return cutOffPosition;
    }

    private void concat() throws BGSException {
        try {
            File outputScoreFile = new File(String.valueOf(this.baseDir) + this.ouputScoreFilePath);
            FileOutputStream fos = new FileOutputStream(outputScoreFile, false);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            BufferedWriter bw = new BufferedWriter(osw);
            File outputMol2File = new File(String.valueOf(this.baseDir) + this.outputMol2FilePath);
            FileOutputStream fos2 = new FileOutputStream(outputMol2File, false);
            OutputStreamWriter osw2 = new OutputStreamWriter((OutputStream)fos2, "UTF-8");
            BufferedWriter bw2 = new BufferedWriter(osw2);
            File inputFile = null;
            FileInputStream fis = null;
            InputStreamReader isr = null;
            BufferedReader br = null;
            bw.write("Name");
            bw.write("\t");
            bw.write("GS");
            bw.write("\t");
            bw.write("Rank");
            bw.newLine();
            int k = 0;
            while (k < this.finalPositions.length) {
                bw.write(this.finalPositions[k].getLigand().getName());
                bw.write("\t");
                bw.write(String.valueOf(this.finalPositions[k].getFitness()));
                bw.write("\t");
                bw.write(String.valueOf(this.finalPositions[k].getRank()));
                bw.newLine();
                inputFile = new File(this.finalPositions[k].getFilePath());
                if (inputFile.exists()) {
                    if (inputFile.canRead()) {
                        fis = new FileInputStream(inputFile);
                        isr = new InputStreamReader(fis);
                        br = new BufferedReader(isr);
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            bw2.write(line);
                            bw2.newLine();
                        }
                        br.close();
                        isr.close();
                        fis.close();
                    } else {
                        BestGoldScorer.logger.warning("You are not allowed to read the following file '" + this.finalPositions[k].getFilePath() + "' !");
                    }
                } else {
                    BestGoldScorer.logger.warning("The following file '" + this.finalPositions[k].getFilePath() + "' does not exist !");
                }
                ++k;
            }
            bw.close();
            osw.close();
            fos.close();
            bw2.close();
            osw2.close();
            fos2.close();
        }
        catch (FileNotFoundException e) {
            throw new BGSException("FileNotFoundException : " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new BGSException("UnsupportedEncodingException : " + e.getMessage());
        }
        catch (IOException e) {
            throw new BGSException("IOException : " + e.getMessage());
        }
    }
}

