/*
 * Decompiled with CFR 0.152.
 */
package fr.u_strasbg.bioinfo_pharma.application.bestGoldScorer;

import fr.u_strasbg.bioinfo_pharma.application.bestGoldScorer.exception.BGSException;
import fr.u_strasbg.bioinfo_pharma.application.bestGoldScorer.processing.Processor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.foata.nicolas.arguments.ArgException;
import org.foata.nicolas.arguments.Arguer;
import org.foata.nicolas.arguments.ArgumentsDefinition;

public class BestGoldScorer {
    private static final long serialVersionUID = 1L;
    private static final String[] KEEP_VALUES = new String[]{"all", "best"};
    public static Logger logger = Logger.getLogger("BestGoldScorer");
    private boolean isHelp;
    private String[] args;
    private String ligandFile;
    private String sizeString;
    private int bundleSize;
    private String keep;
    private String thresholdString;
    private double threshold;
    private String outputScoreFilePath;
    private String outputMol2FilePath;
    private String logLevel;
    private String baseDir;
    private String fileSeparator = System.getProperty("file.separator");

    public BestGoldScorer(String[] args) {
        this.args = args;
    }

    public void init() throws BGSException {
        try {
            List sizes;
            List mol2s;
            String defPath;
            File file;
            this.initLogger();
            String fileSeparator = System.getProperty("file.separator");
            String homePath = System.getenv("BGS_HOME");
            if (homePath.endsWith(fileSeparator)) {
                homePath = homePath.substring(0, homePath.length() - 1);
            }
            if (!(file = new File(defPath = String.valueOf(homePath) + "/etc/conf/bestGoldScorer.def")).isFile()) {
                throw new BGSException("The file bestGoldScorer.def must be a file !");
            }
            if (!file.exists()) {
                throw new BGSException("The file bestGoldScorer.def does not exist.");
            }
            if (!file.canRead()) {
                throw new BGSException("You are not allowed to read that file called mbti.def.");
            }
            ArgumentsDefinition argsDef = ArgumentsDefinition.load((File)file, (String)"org.foata.nicolas.arguments.ArguerAdapter");
            Arguer arguer = argsDef.createArguer();
            arguer.matches(this.args);
            List dirs = arguer.get("directory");
            this.baseDir = dirs != null && dirs.size() > 0 ? (String)dirs.get(0) : "";
            if (this.baseDir == null || this.baseDir.equals("")) {
                this.baseDir = "";
            } else if (this.baseDir.endsWith(fileSeparator)) {
                this.baseDir = this.baseDir.substring(0, this.baseDir.length() - 1);
            }
            List logs = arguer.get("logLevel");
            this.logLevel = logs != null && logs.size() > 0 ? (String)logs.get(0) : "warning";
            if (this.logLevel == null || this.logLevel.equals("")) {
                this.logLevel = "warning";
            }
            logger.setLevel(this.getLogLevel(this.logLevel));
            String outputFilesPath = String.valueOf(homePath) + "/output/results/";
            List scores = arguer.get("score");
            this.outputScoreFilePath = scores != null && scores.size() > 0 ? (String)scores.get(0) : "scores.csv";
            if (this.outputScoreFilePath == null || this.outputScoreFilePath.equals("")) {
                this.outputScoreFilePath = "scores.csv";
            }
            this.outputMol2FilePath = (mol2s = arguer.get("mol2")) != null && mol2s.size() > 0 ? (String)mol2s.get(0) : "poses.mol2";
            if (this.outputMol2FilePath == null || this.outputMol2FilePath.equals("")) {
                this.outputMol2FilePath = "poses.mol2";
            }
            this.sizeString = (sizes = arguer.get("bundle")) != null && sizes.size() > 0 ? (String)sizes.get(0) : "5";
            try {
                this.bundleSize = Integer.valueOf(this.sizeString);
            }
            catch (ClassCastException e) {
                throw new BGSException("The option 'size' must be an integer." + e.getMessage());
            }
            catch (Exception e) {
                throw new BGSException("The option 'size' must be an integer." + e.getMessage());
            }
            List ligandFiles = arguer.get("list");
            this.ligandFile = ligandFiles != null && ligandFiles.size() > 0 ? (String)ligandFiles.get(0) : (this.baseDir == null || this.baseDir.equals("") ? "Lig.list" : "Lig.list");
            List keeps = arguer.get("keep");
            this.keep = keeps != null && keeps.size() > 0 ? (String)keeps.get(0) : "all";
            boolean isGoodKeepValue = false;
            int i = 0;
            while (i < KEEP_VALUES.length) {
                if (this.keep != null && this.keep.equals(KEEP_VALUES[i])) {
                    isGoodKeepValue = true;
                }
                ++i;
            }
            if (!isGoodKeepValue) {
                throw new BGSException("The option 'keep' take only the following values : all , best. ");
            }
            List thresholds = arguer.get("threshold");
            this.thresholdString = thresholds != null && thresholds.size() > 0 ? (String)thresholds.get(0) : "-9999.99";
            try {
                this.threshold = this.thresholdString != null && !this.thresholdString.equals("") ? Double.valueOf(this.thresholdString) : -9999.99;
            }
            catch (ClassCastException e) {
                throw new BGSException("The option 'threshold' must be a double." + e.getMessage());
            }
            catch (Exception e) {
                throw new BGSException("The option 'threshold' must be a double." + e.getMessage());
            }
            this.isHelp = arguer.containsKey("help");
        }
        catch (ArgException e) {
            this.displayHelp();
            throw new BGSException("ArgException : " + e.getMessage());
        }
    }

    public void starts() throws BGSException {
        if (this.isHelp) {
            this.displayHelp();
        } else {
            Processor processor = new Processor();
            if (this.keep.equals("all")) {
                processor.setKeep(0);
            } else if (this.keep.equals("best")) {
                processor.setKeep(1);
            }
            processor.setBundleSize(this.bundleSize);
            processor.setThreshold(this.threshold);
            processor.setOuputScoreFilePath(this.outputScoreFilePath);
            processor.setOutputMol2FilePath(this.outputMol2FilePath);
            processor.setInputLigandFilePath(this.ligandFile);
            if (this.baseDir != null && this.baseDir.equals("")) {
                processor.setBaseDir(this.baseDir);
            } else {
                processor.setBaseDir(String.valueOf(this.baseDir) + this.fileSeparator);
            }
            processor.setPrefixDir("db");
            processor.setSubPrefixDir("db_");
            processor.setSubSuffixDir("_m");
            processor.setMolFileRankExtension(".rnk");
            processor.process();
        }
        logger.exiting("Main", "starts");
    }

    private void initLogger() throws BGSException {
        Object fh = null;
        FileHandler fh2 = null;
        try {
            String fileSeparator = System.getProperty("file.separator");
            String homePath = System.getenv("BGS_HOME");
            if (homePath.endsWith(fileSeparator)) {
                homePath = homePath.substring(0, homePath.length() - 1);
            }
            String logFilePath = String.valueOf(homePath) + "/output/log/bestGoldScorer.log";
            String logDirPath = String.valueOf(homePath) + "/output/log/";
            File dir = new File(logDirPath);
            if (!dir.exists() || !dir.isDirectory()) {
                throw new BGSException("Impossible to find the log directory.");
            }
            fh2 = new FileHandler(logFilePath);
        }
        catch (SecurityException e) {
            throw new BGSException("A SecurityException with the fileHandler occured. " + e.getMessage());
        }
        catch (IOException e) {
            throw new BGSException("An IOException with the fileHandler occured. " + e.getMessage());
        }
        logger.addHandler(fh2);
        logger.setLevel(Level.INFO);
    }

    private void setLogLevel() throws BGSException {
        logger.entering("Main", "setLogLevel");
        logger.setLevel(Level.WARNING);
        logger.exiting("LogP", "setLogLevel");
    }

    private void displayHelp() throws BGSException {
        String usePath;
        File commandFile;
        logger.entering("Main", "displayHelp");
        String fileSeparator = System.getProperty("file.separator");
        String homePath = System.getenv("BGS_HOME");
        if (homePath.endsWith(fileSeparator)) {
            homePath = homePath.substring(0, homePath.length() - 1);
        }
        if (!(commandFile = new File(usePath = String.valueOf(homePath) + "/etc/conf/bestGoldScorer.use")).exists()) {
            throw new BGSException("The file bestGoldScorer.use does not exist.");
        }
        if (!commandFile.canRead()) {
            throw new BGSException("You are not allowed to read that file called bestGoldScorer.use.");
        }
        try {
            FileInputStream fis = new FileInputStream(commandFile);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            br.close();
            isr.close();
            fis.close();
        }
        catch (FileNotFoundException e1) {
            throw new BGSException("FileNotFoundException : " + e1.getMessage());
        }
        catch (UnsupportedEncodingException e1) {
            throw new BGSException("UnsupportedEncodingException : " + e1.getMessage());
        }
        catch (IOException e1) {
            throw new BGSException("IOException : " + e1.getMessage());
        }
        catch (Exception e) {
            throw new BGSException("Unknown Exception : " + e.getMessage());
        }
        logger.exiting("Main", "displayHelp");
    }

    public static void main(String[] args) {
        try {
            BestGoldScorer bgs = new BestGoldScorer(args);
            bgs.init();
            bgs.starts();
        }
        catch (BGSException e) {
            System.err.println("BGSException : " + e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    private Level getLogLevel(String logLevelString) {
        if (logLevelString == null || logLevelString.equalsIgnoreCase("") || logLevelString.equals("info")) {
            return Level.INFO;
        }
        return Level.WARNING;
    }
}

